/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.data;

import com.threerings.getdown.Log;
import com.threerings.getdown.data.ClassPath;
import com.threerings.getdown.data.Digest;
import com.threerings.getdown.data.EnvConfig;
import com.threerings.getdown.data.PathBuilder;
import com.threerings.getdown.data.Resource;
import com.threerings.getdown.data.SysProps;
import com.threerings.getdown.data.a;
import com.threerings.getdown.data.b;
import com.threerings.getdown.data.d;
import com.threerings.getdown.net.Connector;
import com.threerings.getdown.util.Base64;
import com.threerings.getdown.util.Color;
import com.threerings.getdown.util.Config;
import com.threerings.getdown.util.FileUtil;
import com.threerings.getdown.util.HostWhitelist;
import com.threerings.getdown.util.LaunchUtil;
import com.threerings.getdown.util.MessageUtil;
import com.threerings.getdown.util.ProgressAggregator;
import com.threerings.getdown.util.ProgressObserver;
import com.threerings.getdown.util.Rectangle;
import com.threerings.getdown.util.StreamUtil;
import com.threerings.getdown.util.StringUtil;
import com.threerings.getdown.util.VersionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.GeneralSecurityException;
import java.security.Signature;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Application {
    public static final String CONFIG_FILE = "getdown.txt";
    public static final String VERSION_FILE = "version.txt";
    public static final String PROP_PASSTHROUGH_PREFIX = "app.";
    public static final String SIGNATURE_SUFFIX = ".sig";
    public static final String MANIFEST_CLASS = "manifest";
    public Connector conn = Connector.DEFAULT;
    protected final EnvConfig _envc;
    protected Digest _digest;
    protected long _version = -1L;
    protected long _targetVersion = -1L;
    protected String _appbase;
    protected URL _vappbase;
    protected URL _latest;
    protected String _class;
    protected String _dockName;
    protected String _dockIconPath;
    protected boolean _strictComments;
    protected boolean _allowOffline;
    protected int _maxConcDownloads;
    protected String _trackingURL;
    protected Set<Integer> _trackingPcts;
    protected String _trackingCookieName;
    protected String _trackingCookieProperty;
    protected String _trackingURLSuffix;
    protected String _trackingGAHash;
    protected long _trackingStart;
    protected int _trackingId;
    protected String _javaVersionProp = "java.version";
    protected String _javaVersionRegex = "(\\d+)(?:\\.(\\d+)(?:\\.(\\d+)([_.]\\d+)?)?)?";
    protected long _javaMinVersion;
    protected long _javaMaxVersion;
    protected boolean _javaExactVersionRequired;
    protected String _javaLocation;
    protected File _javaLocalDir;
    protected final List<Resource> _codes = new ArrayList<Resource>();
    protected final List<Resource> _resources = new ArrayList<Resource>();
    protected final List<String> _cleanupPatterns = new ArrayList<String>();
    protected final List<String> _cpdirs = new ArrayList<String>();
    protected int _verifyTimeout = 60;
    protected RevalidatePolicy _revalidatePolicy = RevalidatePolicy.AFTER_UPDATE;
    protected boolean _useCodeCache;
    protected int _codeCacheRetentionDays;
    protected final Map<String, AuxGroup> _auxgroups = new HashMap<String, AuxGroup>();
    protected final Map<String, Boolean> _auxactive = new HashMap<String, Boolean>();
    protected final List<String> _jvmargs = new ArrayList<String>();
    protected final List<String> _appargs = new ArrayList<String>();
    protected String[] _optimumJvmArgs;
    protected final List<String> _txtJvmArgs = new ArrayList<String>();
    protected FileLock _lock;
    protected FileChannel _lockChannel;
    protected final Random _rando = new Random();
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected static final String ENV_VAR_PREFIX = "%ENV.";
    protected static final Pattern ENV_VAR_PATTERN = Pattern.compile("%ENV\\.(.*?)%");

    public static Config readConfig(EnvConfig envConfig, boolean bl) {
        Config config = null;
        File file = new File(envConfig.appDir, CONFIG_FILE);
        Object object = Config.createOpts(bl);
        try {
            if (file.exists()) {
                config = Config.parseConfig(file, (Config.ParseOpts)object);
            } else {
                file = new File(envConfig.appDir, "getdown.txt_old");
                if (file.exists()) {
                    config = Config.parseConfig(file, (Config.ParseOpts)object);
                } else {
                    Log.log.info("Found no getdown.txt file", "appdir", envConfig.appDir);
                }
            }
        }
        catch (Exception exception) {
            Log.log.warning("Failure reading config file", "file", config, exception);
        }
        if (config == null) {
            Log.log.info("Using 'appbase' from bootstrap config", "appbase", envConfig.appBase);
            object = new HashMap<String, String>();
            object.put("appbase", envConfig.appBase);
            config = new Config((Map<String, Object>)object);
        }
        return config;
    }

    public Application(EnvConfig envConfig) {
        this._envc = envConfig;
    }

    public File getAppDir() {
        return this._envc.appDir;
    }

    public boolean useCodeCache() {
        return this._useCodeCache;
    }

    public int getCodeCacheRetentionDays() {
        return this._codeCacheRetentionDays;
    }

    public int maxConcurrentDownloads() {
        return this._maxConcDownloads;
    }

    public Resource getConfigResource() {
        try {
            return this.createResource(CONFIG_FILE, Resource.NORMAL);
        }
        catch (Exception exception) {
            throw new RuntimeException("Invalid appbase '" + String.valueOf(this._vappbase) + "'.", exception);
        }
    }

    public List<Resource> getCodeResources() {
        return this._codes;
    }

    public List<Resource> getResources() {
        return this._resources;
    }

    public List<String> getClassPathDirectories() {
        return this._cpdirs;
    }

    public String getDigest(Resource resource) {
        return this._digest.getDigest(resource);
    }

    public List<String> cleanupPatterns() {
        return this._cleanupPatterns;
    }

    public List<Resource> getAllActiveResources() {
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        arrayList.addAll(this.getActiveCodeResources());
        arrayList.addAll(this.getActiveResources());
        return arrayList;
    }

    public AuxGroup getAuxGroup(String string) {
        return this._auxgroups.get(string);
    }

    public Iterable<AuxGroup> getAuxGroups() {
        return this._auxgroups.values();
    }

    public boolean isAuxGroupActive(String string) {
        Boolean bl = this._auxactive.get(string);
        if (bl == null) {
            bl = this.getLocalPath(string + ".dat").exists();
            this._auxactive.put(string, bl);
        }
        return bl;
    }

    public List<Resource> getActiveCodeResources() {
        ArrayList<Resource> arrayList = new ArrayList<Resource>(this.getCodeResources());
        for (AuxGroup auxGroup : this.getAuxGroups()) {
            if (!this.isAuxGroupActive(auxGroup.name)) continue;
            arrayList.addAll(auxGroup.codes);
        }
        return arrayList;
    }

    public List<Resource> getNativeResources() {
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        for (Resource resource : this._resources) {
            if (!resource.isNative()) continue;
            arrayList.add(resource);
        }
        return arrayList;
    }

    public List<Resource> getActiveResources() {
        ArrayList<Resource> arrayList = new ArrayList<Resource>(this.getResources());
        for (AuxGroup auxGroup : this.getAuxGroups()) {
            if (!this.isAuxGroupActive(auxGroup.name)) continue;
            arrayList.addAll(auxGroup.rsrcs);
        }
        return arrayList;
    }

    public Resource getPatchResource(String object) {
        if (this._targetVersion <= this._version) {
            Log.log.warning("Requested patch resource for up-to-date or non-versioned application", "cvers", this._version, "tvers", this._targetVersion);
            return null;
        }
        object = object == null ? "" : "-" + (String)object;
        object = "patch" + (String)object + this._version + ".dat";
        try {
            Application application = this;
            URL uRL = new URL(application.createVAppBase(application._targetVersion), Application.encodePath((String)object));
            return new Resource((String)object, uRL, this.getLocalPath((String)object), Resource.NORMAL);
        }
        catch (Exception exception) {
            Log.log.warning("Failed to create patch resource path", "pfile", object, "appbase", this._appbase, "tvers", this._targetVersion, "error", exception);
            return null;
        }
    }

    public File getJavaLocalDir() {
        return this._javaLocalDir;
    }

    public Resource getJavaVMResource() {
        if (StringUtil.isBlank(this._javaLocation)) {
            return null;
        }
        Object object = this._javaLocation.substring(this._javaLocation.lastIndexOf(46));
        object = this._javaLocalDir.getName() + (String)object;
        try {
            Application application = this;
            URL uRL = new URL(application.createVAppBase(application._targetVersion), Application.encodePath(this._javaLocation));
            return new Resource((String)object, uRL, this.getLocalPath((String)object), EnumSet.of(Resource.Attr.UNPACK, Resource.Attr.CLEAN));
        }
        catch (Exception exception) {
            Log.log.warning("Failed to create VM resource", "vmfile", object, "appbase", this._appbase, "tvers", this._targetVersion, "javaloc", this._javaLocation, "error", exception);
            return null;
        }
    }

    public Resource getFullResource() {
        String string = "full";
        try {
            Application application = this;
            URL uRL = new URL(application.createVAppBase(application._targetVersion), Application.encodePath(string));
            return new Resource(string, uRL, this.getLocalPath(string), Resource.NORMAL);
        }
        catch (Exception exception) {
            Log.log.warning("Failed to create full resource path", "file", string, "appbase", this._appbase, "tvers", this._targetVersion, "error", exception);
            return null;
        }
    }

    public URL getTrackingURL(String string) {
        try {
            String string2 = this._trackingURLSuffix == null ? "" : this._trackingURLSuffix;
            String string3 = this.getGATrackingCode();
            if (this._trackingURL == null) {
                return null;
            }
            return HostWhitelist.verify(new URL(this._trackingURL + Application.encodePath(string + string2 + string3)));
        }
        catch (MalformedURLException malformedURLException) {
            Log.log.warning("Invalid tracking URL", "path", this._trackingURL, "event", string, "error", malformedURLException);
            return null;
        }
    }

    public URL getTrackingProgressURL(int n2) {
        if (this._trackingPcts == null || !this._trackingPcts.contains(n2)) {
            return null;
        }
        return this.getTrackingURL("pct" + n2);
    }

    public String getTrackingCookieName() {
        return this._trackingCookieName;
    }

    public String getTrackingCookieProperty() {
        return this._trackingCookieProperty;
    }

    public Config init(boolean bl) throws IOException {
        Config config = Application.readConfig(this._envc, bl);
        this.initBase(config);
        this.initJava(config);
        this.initTracking(config);
        this.initResources(config);
        this.initCleanupPatterns(config);
        this.initArgs(config);
        return config;
    }

    public void initBase(Config config) throws IOException {
        this._version = config.getLong("version", -1L);
        this._appbase = config.getString("appbase");
        if (this._appbase == null) {
            throw new RuntimeException("m.missing_appbase");
        }
        this._appbase = this.resolveEnvVars(SysProps.overrideAppbase(this._appbase));
        if (!this._appbase.endsWith("/")) {
            this._appbase = this._appbase + "/";
        }
        try {
            this._vappbase = this.createVAppBase(this._version);
        }
        catch (MalformedURLException malformedURLException) {
            String string = MessageUtil.tcompose("m.invalid_appbase", this._appbase);
            throw new IOException(string, malformedURLException);
        }
        Object object = config.getString("latest");
        if (object != null) {
            object = ((String)(object = this.processArg((String)object))).startsWith(this._appbase) ? this._appbase + ((String)object).substring(this._appbase.length()) : SysProps.replaceDomain((String)object);
            try {
                this._latest = HostWhitelist.verify(new URL((String)object));
            }
            catch (MalformedURLException malformedURLException) {
                Log.log.warning("Invalid URL for latest attribute.", malformedURLException);
            }
        }
        this._strictComments = config.getBoolean("strict_comments");
        this._allowOffline = config.getBoolean("allow_offline");
        this._revalidatePolicy = config.getEnum("revalidate_policy", RevalidatePolicy.class, RevalidatePolicy.AFTER_UPDATE);
        int n2 = SysProps.threadPoolSize();
        this._maxConcDownloads = Math.max(1, config.getInt("max_concurrent_downloads", n2));
        this._verifyTimeout = config.getInt("verify_timeout", 60);
        this._useCodeCache = config.getBoolean("use_code_cache");
        this._codeCacheRetentionDays = config.getInt("code_cache_retention_days", 7);
    }

    public void initJava(Config config) {
        this._javaVersionProp = config.getString("java_version_prop", this._javaVersionProp);
        this._javaVersionRegex = config.getString("java_version_regex", this._javaVersionRegex);
        this._javaMinVersion = config.getLong("java_version", this._javaMinVersion);
        this._javaMinVersion = config.getLong("java_min_version", this._javaMinVersion);
        this._javaMaxVersion = config.getLong("java_max_version", this._javaMaxVersion);
        this._javaExactVersionRequired = config.getBoolean("java_exact_version_required");
        Object object = config.getRaw("java_location");
        if (object instanceof String) {
            this._javaLocation = (String)object;
        }
        this._javaLocalDir = this.getLocalPath(config.getString("java_local_dir", "java_vm"));
    }

    public void initTracking(Config config) {
        this._trackingURL = config.getString("tracking_url");
        Object object = config.getString("tracking_percents");
        if (!StringUtil.isBlank((String)object)) {
            this._trackingPcts = new HashSet<Integer>();
            int[] nArray = StringUtil.parseIntArray((String)object);
            object = nArray;
            int n2 = nArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object2 = object[i2];
                this._trackingPcts.add((int)object2);
            }
        } else if (!StringUtil.isBlank(this._trackingURL)) {
            this._trackingPcts = new HashSet<Integer>();
            this._trackingPcts.add(50);
        }
        this._trackingCookieName = config.getString("tracking_cookie_name");
        this._trackingCookieProperty = config.getString("tracking_cookie_property");
        this._trackingURLSuffix = config.getString("tracking_url_suffix");
        this._trackingGAHash = config.getString("tracking_ga_hash");
    }

    public void initResources(Config config) throws IOException {
        this._codes.clear();
        this._resources.clear();
        this._auxgroups.clear();
        if (config.getMultiValue("code") == null && config.getMultiValue("ucode") == null) {
            throw new IOException("m.missing_code");
        }
        this.parseResources(config, "code", Resource.NORMAL, this._codes);
        this.parseResources(config, "ucode", Resource.UNPACK, this._codes);
        this.parseResources(config, "resource", Resource.NORMAL, this._resources);
        this.parseResources(config, "uresource", Resource.UNPACK, this._resources);
        this.parseResources(config, "xresource", Resource.EXEC, this._resources);
        this.parseResources(config, "presource", Resource.PRELOAD, this._resources);
        this.parseResources(config, "nresource", Resource.NATIVE, this._resources);
        for (String string : config.getList("auxgroups")) {
            ArrayList<Resource> arrayList = new ArrayList<Resource>();
            this.parseResources(config, string + ".code", Resource.NORMAL, arrayList);
            this.parseResources(config, string + ".ucode", Resource.UNPACK, arrayList);
            ArrayList<Resource> arrayList2 = new ArrayList<Resource>();
            this.parseResources(config, string + ".resource", Resource.NORMAL, arrayList2);
            this.parseResources(config, string + ".xresource", Resource.EXEC, arrayList2);
            this.parseResources(config, string + ".uresource", Resource.UNPACK, arrayList2);
            this.parseResources(config, string + ".presource", Resource.PRELOAD, arrayList2);
            this.parseResources(config, string + ".nresource", Resource.NATIVE, arrayList2);
            this._auxgroups.put(string, new AuxGroup(string, arrayList, arrayList2));
        }
    }

    public void initCleanupPatterns(Config stringArray) {
        this._cleanupPatterns.clear();
        stringArray = stringArray.getMultiValue("cleanup_pattern");
        if (stringArray == null) {
            return;
        }
        this._cleanupPatterns.addAll(Arrays.asList(stringArray));
    }

    public void initArgs(Config config) throws IOException {
        this._jvmargs.clear();
        this._appargs.clear();
        this._txtJvmArgs.clear();
        this._cpdirs.clear();
        String string = this._envc.appId == null ? "" : this._envc.appId + ".";
        this._class = config.getString("class");
        if (string.length() > 0) {
            this._class = config.getString(string + "class", this._class);
        }
        if (this._class == null) {
            throw new IOException("m.missing_class");
        }
        Application.addAll(config.getMultiValue("jvmarg"), this._jvmargs);
        if (string.length() > 0) {
            Application.addAll(config.getMultiValue(string + "jvmarg"), this._jvmargs);
        }
        this._optimumJvmArgs = config.getMultiValue("optimum_jvmarg");
        Application.addAll(config.getMultiValue(string + "apparg"), this._appargs);
        this._appargs.addAll(this._envc.appArgs);
        this.fillAssignmentListFromPairs("extra.txt", this._txtJvmArgs);
        Application.addAll(config.getMultiValue(string + "classpath"), this._cpdirs);
        this._dockName = config.getString("ui.name");
        this._dockIconPath = config.getString("ui.mac_dock_icon", "../desktop.icns");
    }

    protected void fillAssignmentListFromPairs(String object, List<String> list) {
        if (((File)(object = this.getLocalPath((String)object))).exists()) {
            try {
                Object object2 = Config.parsePairs((File)object, Config.createOpts(false));
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    String[] stringArray = (String[])object2.next();
                    if (stringArray[1].length() == 0) {
                        list.add(stringArray[0]);
                        continue;
                    }
                    list.add(stringArray[0] + "=" + stringArray[1]);
                }
                return;
            }
            catch (Throwable throwable) {
                Log.log.warning("Failed to parse '" + String.valueOf(object) + "': " + String.valueOf(throwable), new Object[0]);
            }
        }
    }

    public URL getRemoteURL(String string) throws MalformedURLException {
        return new URL(this._vappbase, Application.encodePath(string));
    }

    public File getLocalPath(String string) {
        return new File(this.getAppDir(), string);
    }

    public boolean haveValidJavaVersion() {
        if (this._javaMinVersion == 0L && this._javaMaxVersion == 0L) {
            return true;
        }
        try {
            boolean bl;
            long l2 = SysProps.parseJavaVersion(this._javaVersionProp, this._javaVersionRegex);
            Log.log.info("Checking Java version", "current", l2, "wantMin", this._javaMinVersion, "wantMax", this._javaMaxVersion);
            Comparable<Resource> comparable = this.getJavaVMResource();
            if (comparable != null && comparable.isMarkedValid()) {
                comparable = new File(this._javaLocalDir, "release");
                if (!((File)comparable).exists()) {
                    Log.log.warning("Unpacked JVM missing 'release' file. Assuming valid version.", new Object[0]);
                    return true;
                }
                long l3 = VersionUtil.readReleaseVersion((File)comparable, this._javaVersionRegex);
                if (l3 == 0L) {
                    Log.log.warning("Unable to read version from 'release' file. Assuming valid.", new Object[0]);
                    return true;
                }
                l2 = l3;
                Log.log.info("Checking version of unpacked JVM [vers=" + l2 + "].", new Object[0]);
            }
            if (this._javaExactVersionRequired) {
                if (l2 == this._javaMinVersion) {
                    return true;
                }
                Log.log.warning("An exact Java VM version is required.", "current", l2, "required", this._javaMinVersion);
                return false;
            }
            boolean bl2 = this._javaMinVersion == 0L || l2 >= this._javaMinVersion;
            boolean bl3 = bl = this._javaMaxVersion == 0L || l2 <= this._javaMaxVersion;
            return bl2 && bl;
        }
        catch (RuntimeException runtimeException) {
            Log.log.warning("Unable to parse VM version, hoping for the best", "error", runtimeException, "needed", this._javaMinVersion);
            return true;
        }
    }

    public boolean hasOptimumJvmArgs() {
        return this._optimumJvmArgs != null;
    }

    public boolean allowOffline() {
        return this._allowOffline;
    }

    public void attemptRecovery(StatusDisplay statusDisplay) throws IOException {
        statusDisplay.updateStatus("m.updating_metadata");
        this.downloadConfigFile();
    }

    public void updateMetadata() throws IOException {
        try {
            this._vappbase = this.createVAppBase(this._targetVersion);
        }
        catch (MalformedURLException malformedURLException) {
            String string = MessageUtil.tcompose("m.invalid_appbase", this._appbase);
            throw new IOException(string, malformedURLException);
        }
        try {
            this.downloadDigestFiles();
            this.downloadConfigFile();
            return;
        }
        catch (IOException iOException) {
            if (this._allowOffline) {
                Log.log.warning("Failed to update digest files.  Attempting offline operaton.", iOException);
                if (!FileUtil.deleteHarder(this.getLocalPath(VERSION_FILE))) {
                    Log.log.warning("Deleting version.txt failed.  This probably isn't going to work.", new Object[0]);
                    return;
                }
            } else {
                throw iOException;
            }
            return;
        }
    }

    public Process createProcess(boolean bl) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(LaunchUtil.getJVMBinaryPath(this._javaLocalDir, SysProps.debug() || bl));
        boolean bl2 = MANIFEST_CLASS.equals(this._class);
        ClassPath classPath = PathBuilder.buildClassPath(this);
        if (!bl2) {
            arrayList.add("-classpath");
            arrayList.add(classPath.asArgumentString(this.getAppDir()));
        }
        if (LaunchUtil.isMacOS()) {
            Application application = this;
            arrayList.add("-Xdock:icon=" + application.getLocalPath(application._dockIconPath).getAbsolutePath());
            arrayList.add("-Xdock:name=" + this._dockName);
        }
        this.conn.addProxyArgs(arrayList);
        arrayList.add("-Dcom.threerings.getdown=true");
        Object object = PathBuilder.buildLibsPath(this, true);
        if (object != null) {
            arrayList.add("-Djava.library.path=" + ((ClassPath)object).asArgumentString(this.getAppDir()));
        }
        for (Map.Entry object2 : System.getProperties().entrySet()) {
            String string = (String)object2.getKey();
            if (!string.startsWith(PROP_PASSTHROUGH_PREFIX)) continue;
            string = string.substring(4);
            arrayList.add("-D" + string + "=" + String.valueOf(object2.getValue()));
        }
        for (String string : this._jvmargs) {
            arrayList.add(this.processArg(string));
        }
        if (bl && this._optimumJvmArgs != null) {
            object = this._optimumJvmArgs;
            int string = this._optimumJvmArgs.length;
            for (int i2 = 0; i2 < string; ++i2) {
                String string2 = object[i2];
                arrayList.add(this.processArg(string2));
            }
        }
        for (String objectArray : this._txtJvmArgs) {
            arrayList.add(this.processArg(objectArray));
        }
        if (bl2) {
            arrayList.add("-jar");
            arrayList.add(classPath.asArgumentString(this.getAppDir()));
        } else {
            arrayList.add(this._class);
        }
        for (String string : this._appargs) {
            arrayList.add(this.processArg(string));
        }
        object = this.createEnvironment();
        ArrayList<String> arrayList2 = arrayList;
        Object[] objectArray = arrayList2.toArray(new String[arrayList2.size()]);
        Log.log.info("Running " + StringUtil.join(objectArray, "\n  "), new Object[0]);
        return Runtime.getRuntime().exec((String[])objectArray, (String[])object, this.getAppDir());
    }

    protected String[] createEnvironment() {
        Object[] objectArray = new ArrayList<String>();
        this.fillAssignmentListFromPairs("env.txt", (List<String>)objectArray);
        if (objectArray.isEmpty()) {
            Log.log.info("Didn't find any custom environment variables, not setting any.", new Object[0]);
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (String object : objectArray) {
            arrayList.add(this.processArg(object));
        }
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            arrayList.add(entry.getKey() + "=" + entry.getValue());
        }
        ArrayList<Object> arrayList2 = arrayList;
        objectArray = arrayList2.toArray(new String[arrayList2.size()]);
        Log.log.info("Environment " + StringUtil.join(objectArray, "\n "), new Object[0]);
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    public void invokeDirect() throws IOException {
        void var4_12;
        Object object;
        void entry;
        Object object2 = PathBuilder.buildClassPath(this);
        object2 = ((ClassPath)object2).asUrls();
        a a2 = new a(this, (URL[])object2, ClassLoader.getSystemClassLoader());
        Thread.currentThread().setContextClassLoader(a2);
        Log.log.info("Configured URL class loader:", new Object[0]);
        int n2 = ((URL[])object2).length;
        boolean n22 = false;
        while (entry < n2) {
            object = object2[entry];
            Log.log.info("  " + String.valueOf(object), new Object[0]);
            ++entry;
        }
        for (String string : this._jvmargs) {
            if (!string.startsWith("-D")) continue;
            int entry2 = (string = this.processArg(string.substring(2))).indexOf(61);
            if (entry2 == -1) {
                Log.log.warning("Bogus system property: '" + string + "'?", new Object[0]);
                continue;
            }
            System.setProperty(string.substring(0, entry2), string.substring(entry2 + 1));
        }
        object2 = new HashMap();
        for (Map.Entry<Object, Object> clazz : System.getProperties().entrySet()) {
            object = (String)clazz.getKey();
            if (!((String)object).startsWith(PROP_PASSTHROUGH_PREFIX)) continue;
            object = ((String)object).substring(4);
            object2.put(object, (String)clazz.getValue());
        }
        for (Map.Entry<Object, Object> exception : object2.entrySet()) {
            System.setProperty((String)exception.getKey(), (String)exception.getValue());
        }
        Iterator<Map.Entry<Object, Object>> iterator = new String[this._appargs.size()];
        boolean bl = false;
        while (var4_12 < ((Iterator<Map.Entry<Object, Object>>)iterator).length) {
            Application application = this;
            iterator[var4_12] = application.processArg(application._appargs.get((int)var4_12));
            ++var4_12;
        }
        try {
            Log.log.info("Loading " + this._class, new Object[0]);
            Class<?> clazz = a2.loadClass(this._class);
            object = clazz.getMethod("main", EMPTY_STRING_ARRAY.getClass());
            Log.log.info("Invoking main({" + StringUtil.join(iterator, ", ") + "})", new Object[0]);
            ((Method)object).invoke(null, iterator);
            return;
        }
        catch (Exception exception) {
            Log.log.warning("Failure invoking app main", exception);
            return;
        }
    }

    protected String processArg(String string) {
        string = string.replace("%APPDIR%", this.getAppDir().getAbsolutePath());
        string = string.replace("%VERSION%", String.valueOf(this._version));
        string = this.resolveEnvVars(string);
        return string;
    }

    protected String resolveEnvVars(String object) {
        if (((String)object).contains(ENV_VAR_PREFIX)) {
            StringBuffer stringBuffer = new StringBuffer();
            object = ENV_VAR_PATTERN.matcher((CharSequence)object);
            while (((Matcher)object).find()) {
                Object object2 = ((Matcher)object).group(1);
                String string = System.getenv((String)object2);
                object2 = string == null ? "MISSING-" + (String)object2 : string;
                ((Matcher)object).appendReplacement(stringBuffer, Matcher.quoteReplacement((String)object2));
            }
            ((Matcher)object).appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean verifyMetadata(StatusDisplay object) throws IOException {
        Object object2;
        Log.log.info("Verifying application: " + String.valueOf(this._vappbase), new Object[0]);
        Log.log.info("Version: " + this._version, new Object[0]);
        Log.log.info("Class: " + this._class, new Object[0]);
        try {
            this._digest = new Digest(this.getAppDir(), this._strictComments);
        }
        catch (IOException iOException) {
            Log.log.info("Failed to load digest: " + iOException.getMessage() + ". Attempting recovery...", new Object[0]);
        }
        if (this._version == -1L) {
            object2 = this._digest == null ? "" : this._digest.getMetaDigest();
            try {
                object.updateStatus("m.checking");
                this.downloadDigestFiles();
                this._digest = new Digest(this.getAppDir(), this._strictComments);
                if (!((String)object2).equals(this._digest.getMetaDigest())) {
                    Log.log.info("Unversioned digest changed. Revalidating...", new Object[0]);
                    object.updateStatus("m.validating");
                    this.clearValidationMarkers();
                }
            }
            catch (IOException iOException) {
                Log.log.warning("Failed to refresh non-versioned digest: " + iOException.getMessage() + ". Proceeding...", new Object[0]);
            }
        }
        if (this._digest == null) {
            object.updateStatus("m.updating_metadata");
            this.downloadDigestFiles();
            this._digest = new Digest(this.getAppDir(), this._strictComments);
        }
        if (!this._digest.validateResource((Resource)(object2 = this.getConfigResource()), null)) {
            object.updateStatus("m.updating_metadata");
            this.downloadConfigFile();
            this.downloadDigestFiles();
            this._digest = new Digest(this.getAppDir(), this._strictComments);
            this.clearValidationMarkers();
            if (this._digest.validateResource((Resource)object2, null)) {
                this.init(true);
            } else {
                Log.log.warning("getdown.txt failed to validate even after redownloading. Blindly forging onward.", new Object[0]);
            }
        }
        this._targetVersion = this._version;
        if (this._version == -1L) return this._version != this._targetVersion;
        object2 = this.getLocalPath(VERSION_FILE);
        long l2 = VersionUtil.readVersion((File)object2);
        if (l2 != -1L) {
            this._targetVersion = l2;
        }
        if (this._latest == null) return this._version != this._targetVersion;
        try {
            object = Config.parsePairs(new StringReader(this.conn.fetch(this._latest)), Config.createOpts(false));
            object = object.iterator();
            while (object.hasNext()) {
                String[] stringArray = (String[])object.next();
                if (!"version".equals(stringArray[0])) continue;
                this._targetVersion = Math.max(Long.parseLong(stringArray[1]), this._targetVersion);
                if (l2 == -1L || this._targetVersion <= l2) return this._version != this._targetVersion;
                object = new FileOutputStream((File)object2);
                try {
                    object2 = new PrintStream((OutputStream)object);
                    try {
                        ((PrintStream)object2).println(this._targetVersion);
                        return this._version != this._targetVersion;
                    }
                    finally {
                        ((PrintStream)object2).close();
                    }
                }
                finally {
                    ((FileOutputStream)object).close();
                    return this._version != this._targetVersion;
                }
            }
        }
        catch (Exception exception) {
            Log.log.warning("Unable to retrieve version from latest config file.", exception);
        }
        return this._version != this._targetVersion;
    }

    public void verifyResources(ProgressObserver object, int[] nArray, Set<Resource> set, Set<Resource> set2, Set<Resource> set3) throws InterruptedException {
        ExecutorService executorService = Executors.newFixedThreadPool(SysProps.threadPoolSize());
        LinkedBlockingQueue linkedBlockingQueue = new LinkedBlockingQueue();
        int[] nArray2 = new int[1];
        long l2 = System.currentTimeMillis();
        List<Resource> list = this.getAllActiveResources();
        long[] lArray = new long[list.size()];
        long l3 = 0L;
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            lArray[i2] = list.get(i2).getLocal().length();
            l3 += lArray[i2];
        }
        Object object2 = object;
        object = new ProgressAggregator(new b(this, linkedBlockingQueue, (ProgressObserver)object2), lArray);
        object2 = nArray;
        ConcurrentSkipListSet<Resource> concurrentSkipListSet = new ConcurrentSkipListSet<Resource>(set2);
        ConcurrentSkipListSet concurrentSkipListSet2 = new ConcurrentSkipListSet();
        ConcurrentSkipListSet concurrentSkipListSet3 = new ConcurrentSkipListSet();
        int n2 = 0;
        while (n2 < lArray.length) {
            Resource resource = list.get(n2);
            int n3 = n2++;
            executorService.execute(new d(this, resource, (ProgressAggregator)object, n3, (int[])object2, concurrentSkipListSet3, concurrentSkipListSet, concurrentSkipListSet2, linkedBlockingQueue, nArray2));
        }
        while (nArray2[0] < list.size()) {
            Runnable runnable = (Runnable)linkedBlockingQueue.poll(this._verifyTimeout, TimeUnit.SECONDS);
            if (runnable == null) {
                throw new IllegalStateException("m.verify_timeout");
            }
            runnable.run();
        }
        executorService.shutdown();
        set2.addAll(concurrentSkipListSet);
        set3.addAll(concurrentSkipListSet2);
        set.addAll(concurrentSkipListSet3);
        long l4 = System.currentTimeMillis();
        Log.log.info("Verified resources", "count", list.size(), "alreadyValid", nArray[0], "size", l3 / 1024L + "k", "duration", l4 - l2 + "ms");
    }

    private void verifyResource(Resource resource, ProgressObserver progressObserver, int[] nArray, Set<Resource> set, Set<Resource> set2, Set<Resource> set3) {
        if (this._revalidatePolicy != RevalidatePolicy.ALWAYS && resource.isMarkedValid()) {
            if (nArray != null) {
                nArray[0] = nArray[0] + 1;
            }
            progressObserver.progress(100);
            return;
        }
        try {
            if (this._digest.validateResource(resource, progressObserver)) {
                if (resource.getLocalNew().exists()) {
                    set2.add(resource);
                    return;
                }
                resource.applyAttrs();
                set.add(resource);
                resource.markAsValid();
                return;
            }
        }
        catch (Exception exception) {
            Log.log.info("Failure verifying resource. Requesting redownload...", "rsrc", resource, "error", exception);
        }
        finally {
            progressObserver.progress(100);
        }
        set3.add(resource);
    }

    public void unpackResources(ProgressObserver progressObserver, Set<Resource> object) {
        List<Resource> list = this.getActiveResources();
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            Resource resource = object2.next();
            if (resource.shouldUnpack() && !object.contains(resource)) continue;
            object2.remove();
        }
        object2 = new long[list.size()];
        for (int i2 = 0; i2 < ((Object)object2).length; ++i2) {
            object2[i2] = list.get(i2).getLocal().length();
        }
        ProgressAggregator progressAggregator = new ProgressAggregator(progressObserver, (long[])object2);
        for (int i3 = 0; i3 < ((Object)object2).length; ++i3) {
            object = list.get(i3);
            ProgressObserver progressObserver2 = progressAggregator.startElement(i3);
            try {
                ((Resource)object).unpack();
            }
            catch (IOException iOException) {
                Log.log.warning("Failure unpacking resource", "rsrc", object, iOException);
            }
            progressObserver2.progress(100);
        }
    }

    public void clearValidationMarkers() {
        Application application = this;
        application.clearValidationMarkers(application.getAllActiveResources().iterator());
    }

    public long getVersion() {
        return this._version;
    }

    protected URL createVAppBase(long l2) throws MalformedURLException {
        String string = l2 < 0L ? this._appbase : this._appbase.replace("%VERSION%", String.valueOf(l2));
        return HostWhitelist.verify(new URL(string));
    }

    protected void clearValidationMarkers(Iterator<Resource> iterator) {
        while (iterator.hasNext()) {
            iterator.next().clearMarker();
        }
    }

    protected void downloadConfigFile() throws IOException {
        this.downloadControlFile(CONFIG_FILE, 0);
    }

    public synchronized boolean lockForUpdates() {
        if (this._lock != null && this._lock.isValid()) {
            return true;
        }
        try {
            this._lockChannel = new RandomAccessFile(this.getLocalPath("gettingdown.lock"), "rw").getChannel();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.log.warning("Unable to create lock file", "message", fileNotFoundException.getMessage(), fileNotFoundException);
            return false;
        }
        try {
            this._lock = this._lockChannel.tryLock();
        }
        catch (IOException iOException) {
            Log.log.warning("Unable to create lock", "message", iOException.getMessage(), iOException);
            return false;
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            Log.log.warning("The lock is held elsewhere in this JVM", overlappingFileLockException);
            return false;
        }
        Log.log.info("Able to lock for updates: " + (this._lock != null), new Object[0]);
        return this._lock != null;
    }

    public synchronized void releaseLock() {
        if (this._lock != null) {
            Log.log.info("Releasing lock", new Object[0]);
            try {
                this._lock.release();
            }
            catch (IOException iOException) {
                Log.log.warning("Unable to release lock", "message", iOException.getMessage(), iOException);
            }
            try {
                this._lockChannel.close();
            }
            catch (IOException iOException) {
                Log.log.warning("Unable to close lock channel", "message", iOException.getMessage(), iOException);
            }
            this._lockChannel = null;
            this._lock = null;
        }
    }

    protected void downloadDigestFiles() throws IOException {
        for (int i2 = 1; i2 <= 2; ++i2) {
            this.downloadControlFile(Digest.digestFile(i2), i2);
        }
    }

    protected void downloadControlFile(String string, int n2) throws IOException {
        File file;
        File file2 = this.downloadFile(string);
        if (n2 > 0) {
            if (this._envc.certs.isEmpty()) {
                Log.log.info("No signing certs, not verifying digest.txt", "path", string);
            } else {
                byte[] byArray;
                Object object;
                File serializable2 = this.downloadFile(string + SIGNATURE_SUFFIX);
                try {
                    object = new FileInputStream(serializable2);
                    try {
                        byArray = StreamUtil.toByteArray((InputStream)object);
                    }
                    finally {
                        ((FileInputStream)object).close();
                    }
                }
                finally {
                    FileUtil.deleteHarder(serializable2);
                }
                object = new byte[8192];
                int n3 = 0;
                for (Certificate certificate : this._envc.certs) {
                    try (FileInputStream fileInputStream = new FileInputStream(file2);){
                        int n4;
                        Signature signature = Signature.getInstance(Digest.sigAlgorithm(n2));
                        signature.initVerify(certificate);
                        while ((n4 = fileInputStream.read((byte[])object)) != -1) {
                            signature.update((byte[])object, 0, n4);
                        }
                        if (!signature.verify(Base64.decode(byArray, 0))) {
                            Log.log.info("Signature does not match", "cert", certificate.getPublicKey());
                            continue;
                        }
                        Log.log.info("Signature matches", "cert", certificate.getPublicKey());
                        ++n3;
                    }
                    catch (IOException iOException) {
                        Log.log.warning("Failure validating signature of " + String.valueOf(file2) + ": " + String.valueOf(iOException), new Object[0]);
                    }
                    catch (GeneralSecurityException generalSecurityException) {}
                }
                if (n3 == 0) {
                    FileUtil.deleteHarder(file2);
                    throw new IOException("m.corrupt_digest_signature_error");
                }
            }
        }
        if (!FileUtil.renameTo(file2, file = this.getLocalPath(string))) {
            throw new IOException("Failed to rename(" + String.valueOf(file2) + ", " + String.valueOf(file) + ")");
        }
    }

    protected File downloadFile(String string) throws IOException {
        URL uRL;
        File file = this.getLocalPath(string + "_new");
        try {
            uRL = this.getRemoteURL(string);
        }
        catch (Exception exception) {
            Log.log.warning("Requested to download invalid control file", "appbase", this._vappbase, "path", string, "error", exception);
            throw new IOException("Invalid path '" + string + "'.", exception);
        }
        Log.log.info("Attempting to refetch '" + string + "' from '" + String.valueOf(uRL) + "'.", new Object[0]);
        this.conn.download(uRL, file);
        return file;
    }

    protected Resource createResource(String string, EnumSet<Resource.Attr> enumSet) throws MalformedURLException {
        return new Resource(string, this.getRemoteURL(string), this.getLocalPath(string), enumSet);
    }

    protected static void addAll(String[] stringArray, List<String> list) {
        if (stringArray != null) {
            Collections.addAll(list, stringArray);
        }
    }

    public static List<Integer> intsToList(int[] nArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
        for (int n2 : nArray) {
            arrayList.add(n2);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static List<String> stringsToList(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        return Collections.unmodifiableList(Arrays.asList(stringArray));
    }

    protected void parseResources(Config stringArray, String string, EnumSet<Resource.Attr> enumSet, List<Resource> list) {
        if ((stringArray = stringArray.getMultiValue(string)) == null) {
            return;
        }
        for (String string2 : stringArray) {
            try {
                list.add(this.createResource(string2, enumSet));
            }
            catch (Exception exception) {
                Log.log.warning("Invalid resource '" + string2 + "'. " + String.valueOf(exception), new Object[0]);
            }
        }
    }

    protected String getGATrackingCode() {
        if (this._trackingGAHash == null) {
            return "";
        }
        long l2 = System.currentTimeMillis() / 1000L;
        if (this._trackingStart == 0L) {
            this._trackingStart = l2;
        }
        if (this._trackingId == 0) {
            this._trackingId = 100000000 + this._rando.nextInt(900000000);
        }
        StringBuilder stringBuilder = new StringBuilder("&utmcc=__utma%3D").append(this._trackingGAHash);
        stringBuilder.append(".").append(this._trackingId);
        stringBuilder.append(".").append(this._trackingStart).append(".").append(this._trackingStart);
        stringBuilder.append(".").append(l2).append(".1%3B%2B");
        stringBuilder.append("__utmz%3D").append(this._trackingGAHash).append(".");
        stringBuilder.append(this._trackingStart).append(".1.1.");
        stringBuilder.append("utmcsr%3D(direct)%7Cutmccn%3D(direct)%7Cutmcmd%3D(none)%3B");
        stringBuilder.append("&utmn=").append(this._rando.nextInt(1000000000));
        return stringBuilder.toString();
    }

    protected static String encodePath(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8").replace("%2F", "/").replace("+", "%20");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.log.warning("Failed to URL encode " + string + ": " + String.valueOf(unsupportedEncodingException), new Object[0]);
            return string;
        }
    }

    static /* synthetic */ void access$000(Application application, Resource resource, ProgressObserver progressObserver, int[] nArray, Set set, Set set2, Set set3) {
        application.verifyResource(resource, progressObserver, nArray, set, set2, set3);
    }

    protected static enum RevalidatePolicy {
        ALWAYS,
        AFTER_UPDATE;

    }

    public static class AuxGroup {
        public final String name;
        public final List<Resource> codes;
        public final List<Resource> rsrcs;

        public AuxGroup(String string, List<Resource> list, List<Resource> list2) {
            this.name = string;
            this.codes = Collections.unmodifiableList(list);
            this.rsrcs = Collections.unmodifiableList(list2);
        }
    }

    public static interface StatusDisplay {
        public void updateStatus(String var1);
    }

    public static final class UpdateInterface {
        public final String name;
        public final int background;
        public final List<String> rotatingBackgrounds;
        public final String errorBackground;
        public final List<String> iconImages;
        public final String backgroundImage;
        public final String progressImage;
        public final Rectangle progress;
        public final int progressText;
        public final int progressBar;
        public final Rectangle status;
        public final int statusText;
        public final int textShadow;
        public final String installError;
        public final Rectangle patchNotes;
        public final String patchNotesUrl;
        public final boolean hideDecorations;
        public final boolean hideProgressText;
        public final int minShowSeconds;
        public final Map<Step, List<Integer>> stepPercentages;

        public final String toString() {
            return "[name=" + this.name + ", bg=" + this.background + ", bg=" + this.backgroundImage + ", pi=" + this.progressImage + ", prect=" + String.valueOf(this.progress) + ", pt=" + this.progressText + ", pb=" + this.progressBar + ", srect=" + String.valueOf(this.status) + ", st=" + this.statusText + ", shadow=" + this.textShadow + ", err=" + this.installError + ", nrect=" + String.valueOf(this.patchNotes) + ", notes=" + this.patchNotesUrl + ", stepPercentages=" + String.valueOf(this.stepPercentages) + ", hideProgressText" + this.hideProgressText + ", minShow=" + this.minShowSeconds + "]";
        }

        public UpdateInterface(Config config) {
            this.name = config.getString("ui.name");
            this.progress = config.getRect("ui.progress", new Rectangle(5, 5, 300, 15));
            this.progressText = config.getColor("ui.progress_text", -16777216);
            this.hideProgressText = config.getBoolean("ui.hide_progress_text");
            this.minShowSeconds = config.getInt("ui.min_show_seconds", 5);
            this.progressBar = config.getColor("ui.progress_bar", 0x6699CC);
            this.status = config.getRect("ui.status", new Rectangle(5, 25, 500, 100));
            this.statusText = config.getColor("ui.status_text", -16777216);
            this.textShadow = config.getColor("ui.text_shadow", 0);
            this.hideDecorations = config.getBoolean("ui.hide_decorations");
            this.backgroundImage = config.getString("ui.background_image");
            int n2 = 0.5f < Color.brightness(this.progressText) ? -16777216 : -1;
            this.background = config.getColor("ui.background", n2);
            this.progressImage = config.getString("ui.progress_image");
            this.rotatingBackgrounds = Application.stringsToList(config.getMultiValue("ui.rotating_background"));
            this.iconImages = Application.stringsToList(config.getMultiValue("ui.icon"));
            this.errorBackground = config.getString("ui.error_background");
            Object object = config.getUrl("ui.install_error", null);
            this.installError = object == null ? "m.default_install_error" : MessageUtil.taint(object);
            this.patchNotes = config.getRect("ui.patch_notes", new Rectangle(5, 50, 112, 26));
            this.patchNotesUrl = config.getUrl("ui.patch_notes_url", null);
            object = new EnumMap(Step.class);
            Step[] stepArray = Step.values();
            int n3 = stepArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                Step step;
                Step step2 = step = stepArray[i2];
                ((EnumMap)object).put(step2, step2.defaultPercents);
            }
            for (Step step : Step.values()) {
                String string = config.getString("ui.percents." + step.name());
                if (string == null) continue;
                try {
                    ((EnumMap)object).put(step, Application.intsToList(StringUtil.parseIntArray(string)));
                }
                catch (Exception exception) {
                    Log.log.warning("Failed to parse percentages for " + String.valueOf((Object)step) + ": " + string, new Object[0]);
                }
            }
            this.stepPercentages = Collections.unmodifiableMap(object);
        }

        public static enum Step {
            UPDATE_JAVA(10),
            VERIFY_METADATA(15, 65, 95),
            DOWNLOAD(40),
            PATCH(60),
            VERIFY_RESOURCES(70, 97),
            REDOWNLOAD_RESOURCES(90),
            UNPACK(98),
            LAUNCH(99);

            public final List<Integer> defaultPercents;

            private Step(int ... nArray) {
                this.defaultPercents = Application.intsToList(nArray);
            }
        }
    }
}

