/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.tools;

import com.threerings.getdown.tools.JarDiffCodes;
import com.threerings.getdown.util.ProgressObserver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class JarDiffPatcher
implements JarDiffCodes {
    protected static final int DEFAULT_READ_SIZE = 2048;
    protected static final byte[] newBytes = new byte[2048];
    protected static byte[] oldBytes = new byte[2048];

    public void patchJar(String object, String object2, File object3, ProgressObserver progressObserver) throws IOException {
        object = new File((String)object);
        object2 = new File((String)object2);
        try (ZipFile zipFile = new ZipFile((File)object);){
            object2 = new ZipFile((File)object2);
            try {
                object = JarDiffPatcher.makeOutputStream((File)object, (File)object3);
                try {
                    int n2;
                    object3 = new HashSet();
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    this.determineNameMapping((ZipFile)object2, (Set<String>)object3, hashMap);
                    Object object4 = hashMap.keySet().toArray(new String[hashMap.size()]);
                    HashSet<String> hashSet = new HashSet<String>();
                    Object object5 = zipFile.entries();
                    if (object5 != null) {
                        while (object5.hasMoreElements()) {
                            hashSet.add(object5.nextElement().getName());
                        }
                    }
                    double d2 = hashSet.size() + ((String[])object4).length + ((ZipFile)object2).size();
                    double d3 = 0.0;
                    hashSet.removeAll((Collection<?>)object3);
                    d2 -= (double)object3.size();
                    object3 = ((ZipFile)object2).entries();
                    if (object3 != null) {
                        while (object3.hasMoreElements()) {
                            object5 = (ZipEntry)object3.nextElement();
                            if (!"META-INF/INDEX.JD".equals(((ZipEntry)object5).getName())) {
                                this.updateObserver(progressObserver, d3, d2);
                                d3 += 1.0;
                                this.writeEntry((ZipOutputStream)object, (ZipEntry)object5, (ZipFile)object2);
                                boolean bl = hashSet.remove(((ZipEntry)object5).getName());
                                n2 = bl ? 1 : 0;
                                if (!bl) continue;
                                d2 -= 1.0;
                                continue;
                            }
                            d2 -= 1.0;
                        }
                    }
                    object5 = object4;
                    n2 = ((String[])object4).length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        object4 = object5[i2];
                        String string = (String)hashMap.get(object4);
                        Object object6 = zipFile.getEntry(string);
                        if (object6 == null) {
                            object4 = "move" + string + " " + (String)object4;
                            throw new IOException("error.badmove: " + (String)object4);
                        }
                        object4 = new ZipEntry((String)object4);
                        ((ZipEntry)object4).setTime(((ZipEntry)object6).getTime());
                        ((ZipEntry)object4).setSize(((ZipEntry)object6).getSize());
                        ((ZipEntry)object4).setCompressedSize(((ZipEntry)object6).getCompressedSize());
                        ((ZipEntry)object4).setCrc(((ZipEntry)object6).getCrc());
                        ((ZipEntry)object4).setMethod(((ZipEntry)object6).getMethod());
                        ((ZipEntry)object4).setExtra(((ZipEntry)object6).getExtra());
                        ((ZipEntry)object4).setComment(((ZipEntry)object6).getComment());
                        this.updateObserver(progressObserver, d3, d2);
                        d3 += 1.0;
                        object6 = zipFile.getInputStream((ZipEntry)object6);
                        try {
                            this.writeEntry((ZipOutputStream)object, (ZipEntry)object4, (InputStream)object6);
                        }
                        finally {
                            if (object6 != null) {
                                ((InputStream)object6).close();
                            }
                        }
                        boolean bl = hashSet.remove(string);
                        if (!bl) continue;
                        d2 -= 1.0;
                    }
                    for (String string : hashSet) {
                        ZipEntry zipEntry = zipFile.getEntry(string);
                        if (zipEntry == null) {
                            throw new AssertionError((Object)("Archive entry not found: " + string));
                        }
                        this.updateObserver(progressObserver, d3, d2);
                        d3 += 1.0;
                        this.writeEntry((ZipOutputStream)object, zipEntry, zipFile);
                    }
                    this.updateObserver(progressObserver, d3, d2);
                }
                finally {
                    if (object != null) {
                        ((ZipOutputStream)object).close();
                    }
                }
            }
            finally {
                ((ZipFile)object2).close();
            }
            return;
        }
    }

    protected void updateObserver(ProgressObserver progressObserver, double d2, double d3) {
        if (progressObserver != null) {
            progressObserver.progress((int)(d2 * 100.0 / d3));
        }
    }

    protected void determineNameMapping(ZipFile closeable, Set<String> set, Map<String, String> map) throws IOException {
        ZipFile zipFile = closeable;
        closeable = zipFile.getInputStream(zipFile.getEntry("META-INF/INDEX.JD"));
        if (closeable == null) {
            throw new IOException("error.noindex");
        }
        String string = ((LineNumberReader)(closeable = new LineNumberReader(new InputStreamReader((InputStream)closeable, StandardCharsets.UTF_8)))).readLine();
        if (string == null || !string.equals("version 1.0")) {
            throw new IOException("jardiff.error.badheader: " + string);
        }
        while ((string = ((LineNumberReader)closeable).readLine()) != null) {
            List<String> list;
            if (string.startsWith("remove")) {
                list = this.getSubpaths(string.substring(6));
                if (list.size() != 1) {
                    throw new IOException("error.badremove: " + string);
                }
                set.add(list.get(0));
                continue;
            }
            if (string.startsWith("move")) {
                list = this.getSubpaths(string.substring(4));
                if (list.size() != 2) {
                    throw new IOException("error.badmove: " + string);
                }
                if (map.put(list.get(1), list.get(0)) == null) continue;
                throw new IOException("error.badmove: " + string);
            }
            if (string.length() <= 0) continue;
            throw new IOException("error.badcommand: " + string);
        }
    }

    protected List<String> getSubpaths(String string) {
        int n2 = 0;
        int n3 = string.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (n2 < n3) {
            while (n2 < n3 && Character.isWhitespace(string.charAt(n2))) {
                ++n2;
            }
            if (n2 >= n3) continue;
            int n4 = n2;
            StringBuilder stringBuilder = null;
            while (n2 < n3) {
                char c2 = string.charAt(n2);
                if (c2 == '\\' && n2 + 1 < n3 && string.charAt(n2 + 1) == ' ') {
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder(string.substring(n4, n2));
                    } else {
                        stringBuilder.append(string, n4, n2);
                    }
                    n4 = ++n2;
                } else if (Character.isWhitespace(c2)) break;
                ++n2;
            }
            if (n4 != n2) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(string.substring(n4, n2));
                } else {
                    stringBuilder.append(string, n4, n2);
                }
            }
            if (stringBuilder == null) continue;
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writeEntry(ZipOutputStream zipOutputStream, ZipEntry zipEntry, ZipFile closeable) throws IOException {
        closeable = ((ZipFile)closeable).getInputStream(zipEntry);
        try {
            this.writeEntry(zipOutputStream, zipEntry, (InputStream)closeable);
            if (closeable == null) return;
        }
        catch (Throwable throwable) {
            if (closeable == null) throw throwable;
            try {
                ((InputStream)closeable).close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ((InputStream)closeable).close();
    }

    protected void writeEntry(ZipOutputStream zipOutputStream, ZipEntry zipEntry, InputStream inputStream) throws IOException {
        zipOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
        int n2 = inputStream.read(newBytes);
        while (n2 != -1) {
            zipOutputStream.write(newBytes, 0, n2);
            n2 = inputStream.read(newBytes);
        }
    }

    protected static ZipOutputStream makeOutputStream(File file, File object) throws IOException {
        object = new FileOutputStream((File)object);
        String string = file.getName();
        if (string.endsWith(".jar") || string.endsWith(".jar.old")) {
            return new JarOutputStream((OutputStream)object);
        }
        if (string.endsWith(".zip") || string.endsWith(".zip.old")) {
            return new ZipOutputStream((OutputStream)object);
        }
        throw new AssertionError((Object)("Unsupported source file '" + String.valueOf(file) + "'. Not a .jar or .zip?"));
    }
}

