/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.tools;

import com.threerings.getdown.Log;
import com.threerings.getdown.tools.JarDiffPatcher;
import com.threerings.getdown.tools.a;
import com.threerings.getdown.util.FileUtil;
import com.threerings.getdown.util.ProgressObserver;
import com.threerings.getdown.util.StreamUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Patcher {
    public static final String CREATE = ".create";
    public static final String PATCH = ".patch";
    public static final String DELETE = ".delete";
    protected ProgressObserver _obs;
    protected long _complete;
    protected long _plength;
    protected byte[] _buffer;
    protected static final int COPY_BUFFER_SIZE = 4096;

    public void patch(File file, File object, ProgressObserver object2) throws IOException {
        this._obs = object2;
        this._plength = ((File)object).length();
        object = new ZipFile((File)object);
        try {
            object2 = ((ZipFile)object).entries();
            while (object2.hasMoreElements()) {
                Object object3 = (ZipEntry)object2.nextElement();
                String string = ((ZipEntry)object3).getName();
                long l2 = ((ZipEntry)object3).getCompressedSize();
                if (string.endsWith(CREATE)) {
                    string = this.strip(string, CREATE);
                    Log.log.info("Creating " + string + "...", new Object[0]);
                    this.createFile((ZipFile)object, (ZipEntry)object3, new File(file, string));
                } else if (string.endsWith(PATCH)) {
                    string = this.strip(string, PATCH);
                    Log.log.info("Patching " + string + "...", new Object[0]);
                    this.patchFile((ZipFile)object, (ZipEntry)object3, file, string);
                } else if (string.endsWith(DELETE)) {
                    string = this.strip(string, DELETE);
                    Log.log.info("Removing " + string + "...", new Object[0]);
                    object3 = new File(file, string);
                    if (!FileUtil.deleteHarder((File)object3)) {
                        Log.log.warning("Failure deleting '" + String.valueOf(object3) + "'.", new Object[0]);
                    }
                } else {
                    Log.log.warning("Skipping bogus patch file entry: " + string, new Object[0]);
                }
                this._complete += l2;
            }
            return;
        }
        finally {
            ((ZipFile)object).close();
        }
    }

    protected String strip(String string, String string2) {
        return string.substring(0, string.length() - string2.length());
    }

    protected void createFile(ZipFile closeable, ZipEntry object, File file) {
        File file2;
        if (this._buffer == null) {
            this._buffer = new byte[4096];
        }
        if (!(file2 = file.getParentFile()).exists() && !file2.mkdirs()) {
            Log.log.warning("Failed to create parent for '" + String.valueOf(file) + "'.", new Object[0]);
        }
        try {
            block17: {
                block16: {
                    closeable = ((ZipFile)closeable).getInputStream((ZipEntry)object);
                    try {
                        object = new FileOutputStream(file);
                        try {
                            int n2;
                            int n3 = 0;
                            while ((n2 = ((InputStream)closeable).read(this._buffer)) != -1) {
                                ((FileOutputStream)object).write(this._buffer, 0, n2);
                                this.updateProgress(n3 += n2);
                            }
                        }
                        finally {
                            ((FileOutputStream)object).close();
                        }
                        if (closeable == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (closeable != null) {
                            try {
                                ((InputStream)closeable).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    break block17;
                }
                return;
            }
            ((InputStream)closeable).close();
        }
        catch (IOException iOException) {
            Log.log.warning("Error creating '" + String.valueOf(file) + "': " + String.valueOf(iOException), new Object[0]);
        }
    }

    protected void patchFile(ZipFile closeable, ZipEntry object, File file, String object2) {
        File file2 = new File(file, (String)object2);
        File file3 = new File(file, ((ZipEntry)object).getName());
        file = new File(file, (String)object2 + ".old");
        object2 = null;
        FileUtil.deleteHarder(file);
        try {
            closeable = ((ZipFile)closeable).getInputStream((ZipEntry)object);
            try (FileOutputStream fileOutputStream = new FileOutputStream(file3);){
                StreamUtil.copy((InputStream)closeable, fileOutputStream);
                StreamUtil.close(fileOutputStream);
                if (!FileUtil.renameTo(file2, file)) {
                    Log.log.warning("Failed to .oldify '" + String.valueOf(file2) + "'.", new Object[0]);
                    return;
                }
                long l2 = ((ZipEntry)object).getCompressedSize();
                object = new a(this, l2);
                object2 = new JarDiffPatcher();
                ((JarDiffPatcher)object2).patchJar(file.getPath(), file3.getPath(), file2, (ProgressObserver)object);
            }
            finally {
                if (closeable != null) {
                    ((InputStream)closeable).close();
                }
            }
            return;
        }
        catch (IOException iOException) {
            if (object2 == null) {
                Log.log.warning("Failed to write patch file '" + String.valueOf(file3) + "': " + String.valueOf(iOException), new Object[0]);
            } else {
                Log.log.warning("Error patching '" + String.valueOf(file2) + "': " + String.valueOf(iOException), new Object[0]);
            }
            return;
        }
        finally {
            FileUtil.deleteHarder(file3);
            FileUtil.deleteHarder(file);
        }
    }

    protected void updateProgress(int n2) {
        if (this._obs != null) {
            this._obs.progress((int)(100L * (this._complete + (long)n2) / this._plength));
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.err.println("Usage: Patcher appdir patch_file");
            System.exit(-1);
        }
        Patcher patcher = new Patcher();
        try {
            patcher.patch(new File(stringArray[0]), new File(stringArray[1]), null);
            return;
        }
        catch (IOException iOException) {
            System.err.println("Error: " + iOException.getMessage());
            System.exit(-1);
            return;
        }
    }
}

