/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.util;

import com.threerings.getdown.Log;
import com.threerings.getdown.util.FileUtil;
import com.threerings.getdown.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Locale;

public final class LaunchUtil {
    public static final String LOCAL_JAVA_DIR = "java_vm";
    private static boolean _isWindows;
    private static boolean _isMacOS;
    private static boolean _isLinux;

    public static boolean updateVersionAndRelaunch(File objectArray, String string, String string2, String string3) throws IOException {
        Object object = new File((File)objectArray, "version.txt");
        object = new PrintStream(Files.newOutputStream(((File)object).toPath(), new OpenOption[0]));
        try {
            ((PrintStream)object).println(string2);
        }
        finally {
            ((PrintStream)object).close();
        }
        object = new File((File)objectArray, string);
        if (LaunchUtil.mustMonitorChildren() || !((File)object).exists()) {
            return false;
        }
        string = StringUtil.isBlank(string3) ? LOCAL_JAVA_DIR : string3;
        string2 = LaunchUtil.getJVMBinaryPath(new File((File)objectArray, string), false);
        objectArray = new String[]{string2, "-jar", ((File)object).toString(), objectArray.getPath()};
        Log.log.info("Running " + StringUtil.join(objectArray, "\n  "), new Object[0]);
        try {
            Runtime.getRuntime().exec((String[])objectArray, null);
            return true;
        }
        catch (IOException iOException) {
            Log.log.warning("Failed to run getdown", iOException);
            return false;
        }
    }

    public static String getJVMBinaryPath(File file, boolean bl) {
        String string = LaunchUtil.checkJVMPath(file.getAbsolutePath(), bl);
        if (string == null) {
            string = LaunchUtil.checkJVMPath(System.getProperty("java.home"), bl);
        }
        if (string == null) {
            Log.log.warning("Unable to find java [local=" + String.valueOf(file) + ", java.home=" + System.getProperty("java.home") + "]!", new Object[0]);
            string = "java";
        }
        if (LaunchUtil.isMacOS()) {
            try {
                file = new File("/usr/bin/java").getCanonicalFile();
                if (file.equals(new File(string).getCanonicalFile())) {
                    string = "/usr/bin/java";
                }
            }
            catch (IOException iOException) {
                Log.log.warning("Failed to check Mac OS canonical VM path.", iOException);
            }
        }
        return string;
    }

    public static void upgradeGetdown(File file, File file2, File file3) {
        if (!file3.exists() || file3.length() == file2.length()) {
            return;
        }
        Log.log.info("Updating Getdown with " + String.valueOf(file3) + "...", new Object[0]);
        if (file.exists()) {
            FileUtil.deleteHarder(file);
        }
        if (!file2.exists() || file2.renameTo(file)) {
            if (file3.renameTo(file2)) {
                FileUtil.deleteHarder(file);
                try {
                    FileUtil.copy(file2, file3);
                    return;
                }
                catch (IOException iOException) {
                    Log.log.warning("Error copying updated Getdown back: " + String.valueOf(iOException), new Object[0]);
                    return;
                }
            }
            Log.log.warning("Unable to renameTo(" + String.valueOf(file) + ").", new Object[0]);
            if (!file.renameTo(file2)) {
                Log.log.warning("Oh God, why dost thee scorn me so.", new Object[0]);
            }
        }
        Log.log.info("Attempting to upgrade by copying over " + String.valueOf(file2) + "...", new Object[0]);
        try {
            FileUtil.copy(file3, file2);
            return;
        }
        catch (IOException iOException) {
            Log.log.warning("Mayday! Brute force copy method also failed.", iOException);
            return;
        }
    }

    public static boolean mustMonitorChildren() {
        String string = System.getProperty("os.name", "").toLowerCase(Locale.ROOT);
        return string.contains("windows 98") || string.contains("windows me");
    }

    public static boolean isWindows() {
        return _isWindows;
    }

    public static boolean isMacOS() {
        return _isMacOS;
    }

    public static boolean isLinux() {
        return _isLinux;
    }

    private static String checkJVMPath(String object, boolean bl) {
        String string = File.separator;
        String string2 = (String)(object = (String)object + string + "bin" + string) + "java";
        if (new File(string2).exists()) {
            return string2;
        }
        if (!bl && new File(string2 = (String)object + "javaw.exe").exists()) {
            return string2;
        }
        string2 = (String)object + "java.exe";
        if (new File(string2).exists()) {
            return string2;
        }
        return null;
    }

    static {
        try {
            String string = System.getProperty("os.name");
            string = string == null ? "" : string;
            _isWindows = string.contains("Windows");
            _isMacOS = string.contains("Mac OS") || string.contains("MacOS");
            _isLinux = string.contains("Linux");
        }
        catch (Exception exception) {}
    }
}

