/*
 * Decompiled with CFR 0.152.
 */
package no.statkart.launcher.client;

import com.threerings.getdown.launcher.GetdownApp;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Handler;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import no.statkart.launcher.client.Input;
import no.statkart.launcher.client.Konfigurasjonsverdi;
import no.statkart.launcher.client.Parametre;
import no.statkart.launcher.client.StandardOppsett;
import no.statkart.launcher.client.TjenerKontroll;
import no.statkart.launcher.client.Work;

public class Launcher {
    private final StandardOppsett standard;

    public static void main(String ... args) {
        try {
            StandardOppsett standard = new StandardOppsett(Path.of("work", new String[0]));
            new Launcher(standard).start(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.printf("Kunne ikke starte klienten: %s%n", e.getMessage());
            System.exit(-1);
        }
    }

    Launcher(StandardOppsett standard) {
        this.standard = standard;
    }

    void start(String ... args) throws Exception {
        Input input = new Input(this.standard);
        Parametre parametre = this.finnParametre(input);
        if (parametre == null) {
            System.exit(0);
        }
        parametre.kontroller();
        Work work = this.standard.getWork();
        String workMappe = work.finnEllerOpprettWorkMappe(parametre);
        work.skrivLoginParametre(parametre);
        this.loggTilFil(workMappe + "/launcher.log");
        this.ikkeLoggPassordetFra(parametre);
        this.leggTilEkstraParametre(workMappe + "/extra.txt", parametre, args);
        if (!this.klientAkseptert(parametre)) {
            JOptionPane.showMessageDialog(new JFrame(), "Vennligst last ned matrikkelstarteren p\u00e5 nytt. Du m\u00e5 oppdatere til nyeste versjon.", input.inputTittel(), 0);
            System.exit(-1);
        }
        this.brukTjeneradresseFra(parametre);
        this.registrerKlientversjon();
        GetdownApp.main((String[])new String[]{workMappe});
    }

    private Parametre finnParametre(Input input) throws Exception {
        List<Parametre> forslagTilParametre = this.standard.getWork().lesInputParametre();
        this.fyllInnManglendeStandardVerdier(forslagTilParametre);
        Parametre param = this.standard.getParametre();
        if (input.visTjener()) {
            if (forslagTilParametre.isEmpty()) {
                forslagTilParametre.add(param);
            }
        } else {
            forslagTilParametre = Collections.singletonList(forslagTilParametre.stream().filter(p -> Objects.equals(param.getTjener(), p.getTjener())).findFirst().orElse(param));
        }
        return input.innhentParametre(forslagTilParametre);
    }

    private boolean klientAkseptert(Parametre param) {
        TjenerKontroll kontroll = new TjenerKontroll(this.standard);
        return kontroll.klientAkseptert(param);
    }

    private void fyllInnManglendeStandardVerdier(List<Parametre> paramList) {
        paramList.forEach(p -> {
            if (p.getHeap() == null) {
                p.medHeap(this.standard.getParametre().getHeap());
            }
        });
    }

    private void loggTilFil(String destination) throws IOException {
        File logFile = new File(destination);
        PrintStream logOut = new PrintStream(new BufferedOutputStream(new FileOutputStream(logFile)), true);
        System.setOut(logOut);
        System.setErr(logOut);
        System.setProperty("no_log_redir", "true");
    }

    private void ikkeLoggPassordetFra(Parametre loginParametre) {
        if (loginParametre.getPassord() == null) {
            return;
        }
        Logger logger = Logger.getLogger("");
        for (Handler handler : logger.getHandlers()) {
            handler.setFilter(record -> {
                record.setMessage(this.fjernPassord(record.getMessage(), loginParametre.getPassord()));
                return true;
            });
        }
    }

    private String fjernPassord(String input, char[] passord) {
        return input.replaceAll("\\b\\Q" + String.copyValueOf(passord) + "\\E\\b", "***");
    }

    private void leggTilEkstraParametre(String destination, Parametre loginParametre, String[] args) throws IOException {
        ArrayList<Object> lines = new ArrayList<Object>();
        lines.add("-Xmx" + loginParametre.getHeap() + "m");
        lines.addAll(Arrays.asList(args));
        Path p = Paths.get(destination, new String[0]);
        Files.write(p, lines, new OpenOption[0]);
    }

    private void brukTjeneradresseFra(Parametre parametre) {
        System.setProperty("appbase_domain", parametre.getTjener());
        System.setProperty("app.skif.server_url", parametre.getTjener());
        System.setProperty("app.skif.single_vm", "false");
    }

    private void registrerKlientversjon() {
        String versjon = this.standard.getKonfigurasjon().get(Konfigurasjonsverdi.VERSION);
        if (versjon != null) {
            System.setProperty("app.launcher.version", versjon);
        }
    }
}

