/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.data;

import com.threerings.getdown.Log;
import com.threerings.getdown.cache.GarbageCollector;
import com.threerings.getdown.cache.ResourceCache;
import com.threerings.getdown.data.Application;
import com.threerings.getdown.data.ClassPath;
import com.threerings.getdown.data.Resource;
import com.threerings.getdown.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipFile;

public class PathBuilder {
    public static final String CODE_CACHE_DIR = ".cache";
    public static final String NATIVE_CACHE_DIR = ".ncache";

    public static ClassPath buildClassPath(Application application) throws IOException {
        if (application.useCodeCache()) {
            return PathBuilder.buildCachedClassPath(application);
        }
        return PathBuilder.buildDefaultClassPath(application);
    }

    public static ClassPath buildDefaultClassPath(Application application) {
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        for (Resource resource : application.getActiveCodeResources()) {
            linkedHashSet.add(resource.getFinalTarget());
        }
        PathBuilder.addClassPathDirectories(application, linkedHashSet);
        return new ClassPath(linkedHashSet);
    }

    public static ClassPath buildCachedClassPath(Application application) throws IOException {
        Object object = new File(application.getAppDir(), CODE_CACHE_DIR);
        long l2 = TimeUnit.DAYS.toMillis(application.getCodeCacheRetentionDays());
        if (l2 != 0L) {
            GarbageCollector.collect((File)object, l2);
        }
        object = new ResourceCache((File)object);
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        for (Comparable<Resource> comparable : application.getActiveCodeResources()) {
            String string = application.getDigest((Resource)comparable);
            comparable = ((ResourceCache)object).cacheFile(comparable.getFinalTarget(), string.substring(0, 2), string);
            linkedHashSet.add((File)comparable);
        }
        PathBuilder.addClassPathDirectories(application, linkedHashSet);
        return new ClassPath(linkedHashSet);
    }

    private static void addClassPathDirectories(Application application, Set<File> set) {
        for (String string : application.getClassPathDirectories()) {
            File file = new File(string);
            if (!file.isAbsolute()) {
                file = new File(application.getAppDir(), string);
            }
            set.add(file);
        }
    }

    public static ClassPath buildLibsPath(Application application, boolean bl) throws IOException {
        List<Resource> object = application.getNativeResources();
        if (object.isEmpty()) {
            return null;
        }
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        File file = new File(application.getAppDir(), NATIVE_CACHE_DIR);
        ResourceCache resourceCache = new ResourceCache(file);
        long l2 = TimeUnit.DAYS.toMillis(application.getCodeCacheRetentionDays());
        if (l2 != 0L) {
            GarbageCollector.collectNative(file, l2);
        }
        for (Resource resource : object) {
            Object object2 = application.getDigest(resource);
            String string = object2;
            File file2 = resourceCache.cacheFile(resource.getFinalTarget(), string, string);
            File file3 = file2.getParentFile();
            object2 = new File(file3, file2.getName() + ".unpacked");
            if (!((File)object2).exists()) {
                try {
                    FileUtil.unpackJar(new ZipFile(file2), file3, false);
                    ((File)object2).createNewFile();
                }
                catch (IOException iOException) {
                    Log.log.warning("Failed to unpack native jar", "file", file2.getAbsolutePath(), iOException);
                }
            }
            linkedHashSet.add(file2.getParentFile());
        }
        if (bl) {
            for (String string : System.getProperty("java.library.path").split(File.pathSeparator)) {
                linkedHashSet.add(new File(string));
            }
        }
        return new ClassPath(linkedHashSet);
    }
}

