/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.data;

import com.threerings.getdown.data.Digest;
import com.threerings.getdown.data.SysProps;
import com.threerings.getdown.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class EnvConfig {
    public final File appDir;
    public final String appId;
    public final String appBase;
    public final List<Certificate> certs;
    public final List<String> appArgs;
    private static final String USER_HOME_KEY = "${user.home}";

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EnvConfig create(String[] object, List<Note> list) {
        void var1_2;
        String string;
        String string2;
        Object object2;
        Object object3;
        Object object4 = null;
        Object object5 = null;
        String string3 = null;
        Object object6 = null;
        String string4 = null;
        Object object7 = null;
        try {
            object3 = ResourceBundle.getBundle("bootstrap");
            if (((ResourceBundle)object3).containsKey("appdir")) {
                object4 = ((ResourceBundle)object3).getString("appdir");
                object4 = ((String)object4).replace(USER_HOME_KEY, System.getProperty("user.home"));
                object5 = "bootstrap.properties";
            }
            if (((ResourceBundle)object3).containsKey("appid")) {
                string3 = ((ResourceBundle)object3).getString("appid");
                object6 = "bootstrap.properties";
            }
            if (((ResourceBundle)object3).containsKey("appbase")) {
                string4 = ((ResourceBundle)object3).getString("appbase");
                object7 = "bootstrap.properties";
            }
            object2 = ((ResourceBundle)object3).keySet().iterator();
            while (object2.hasNext()) {
                string2 = (String)object2.next();
                if (!string2.startsWith("sys.")) continue;
                string = string2.substring(4);
                string2 = ((ResourceBundle)object3).getString(string2);
                var1_2.add(Note.info("Setting system property from bundle: " + string + "='" + string2 + "'"));
                System.setProperty(string, string2);
            }
        }
        catch (MissingResourceException missingResourceException) {}
        if (!StringUtil.isBlank((String)(object3 = SysProps.appDir()))) {
            if (object4 == null) {
                object4 = object3;
                object5 = "system property";
            } else {
                var1_2.add(Note.warn("Ignoring 'appdir' system property, have appdir via '" + object5 + "'"));
            }
        }
        if (!StringUtil.isBlank((String)(object2 = SysProps.appId()))) {
            if (string3 == null) {
                string3 = object2;
                object6 = "system property";
            } else {
                var1_2.add(Note.warn("Ignoring 'appid' system property, have appid via '" + (String)object6 + "'"));
            }
        }
        if (!StringUtil.isBlank(string2 = SysProps.appBase())) {
            if (string4 == null) {
                string4 = string2;
                object7 = "system property";
            } else {
                var1_2.add(Note.warn("Ignoring 'appbase' system property, have appbase via '" + (String)object7 + "'"));
            }
        }
        if (!StringUtil.isBlank(string = ((String[])object).length > 0 ? object[0] : null)) {
            if (object4 == null) {
                object4 = string;
                object5 = "command line";
            } else {
                var1_2.add(Note.warn("Ignoring 'appdir' command line arg, have appdir via '" + (String)object5 + "'"));
            }
        }
        if (!StringUtil.isBlank(string2 = ((String[])object).length > 1 ? object[1] : null)) {
            if (string3 == null) {
                string3 = string2;
                object6 = "command line";
            } else {
                var1_2.add(Note.warn("Ignoring 'appid' command line arg, have appid via '" + (String)object6 + "'"));
            }
        }
        if (object4 == null) {
            object4 = System.getProperty("user.dir");
            object5 = "default (cwd)";
        }
        var1_2.add(Note.info("Using appdir from " + (String)object5 + ": " + (String)object4));
        if (string3 != null) {
            var1_2.add(Note.info("Using appid from " + (String)object6 + ": " + string3));
        }
        if (string4 != null) {
            var1_2.add(Note.info("Using appbase from " + (String)object7 + ": " + string4));
        }
        if (!((File)(object5 = new File((String)object4))).exists()) {
            if (StringUtil.isBlank(string4)) {
                var1_2.add(Note.error("Invalid appdir '" + (String)object4 + "': directory does not exist"));
                return null;
            }
            if (((File)object5).mkdirs()) {
                var1_2.add(Note.info("Auto-created app directory '" + (String)object4 + "'"));
            } else {
                var1_2.add(Note.warn("Unable to auto-create app dir: '" + (String)object4 + "'"));
            }
        } else if (!((File)object5).isDirectory()) {
            var1_2.add(Note.error("Invalid appdir '" + (String)object4 + "': refers to non-directory"));
            return null;
        }
        List<String> list2 = ((String[])object).length > 2 ? Arrays.asList(object).subList(2, ((String[])object).length) : Collections.emptyList();
        object4 = new File((File)object5, Digest.digestFile(2) + ".crt");
        object6 = new ArrayList();
        if (!((File)object4).exists()) return new EnvConfig((File)object5, string3, string4, (List<Certificate>)object6, list2);
        try {
            object4 = new FileInputStream((File)object4);
            try {
                object7 = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate((InputStream)object4);
                object6.add(object7);
                return new EnvConfig((File)object5, string3, string4, (List<Certificate>)object6, list2);
            }
            finally {
                ((FileInputStream)object4).close();
            }
        }
        catch (Exception exception) {
            var1_2.add(Note.error("Certificate error: " + exception.getMessage()));
        }
        return new EnvConfig((File)object5, string3, string4, (List<Certificate>)object6, list2);
    }

    public EnvConfig(File file) {
        this(file, null, null, Collections.emptyList(), Collections.emptyList());
    }

    private EnvConfig(File file, String string, String string2, List<Certificate> list, List<String> list2) {
        this.appDir = file;
        this.appId = string;
        this.appBase = string2;
        this.certs = list;
        this.appArgs = list2;
    }

    public static final class Note {
        public final Level level;
        public final String message;

        public static Note info(String string) {
            return new Note(Level.INFO, string);
        }

        public static Note warn(String string) {
            return new Note(Level.WARN, string);
        }

        public static Note error(String string) {
            return new Note(Level.ERROR, string);
        }

        public Note(Level level, String string) {
            this.level = level;
            this.message = string;
        }

        public static enum Level {
            INFO,
            WARN,
            ERROR;

        }
    }
}

