/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.data;

import com.threerings.getdown.Log;
import com.threerings.getdown.data.SysProps;
import com.threerings.getdown.data.g;
import com.threerings.getdown.util.FileUtil;
import com.threerings.getdown.util.ProgressObserver;
import com.threerings.getdown.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Resource
implements Comparable<Resource> {
    public static final EnumSet<Attr> NORMAL = EnumSet.noneOf(Attr.class);
    public static final EnumSet<Attr> UNPACK = EnumSet.of(Attr.UNPACK);
    public static final EnumSet<Attr> EXEC = EnumSet.of(Attr.EXEC);
    public static final EnumSet<Attr> PRELOAD = EnumSet.of(Attr.PRELOAD);
    public static final EnumSet<Attr> NATIVE = EnumSet.of(Attr.NATIVE);
    protected final String _path;
    protected final URL _remote;
    protected final File _local;
    protected final File _localNew;
    protected final File _marker;
    protected File _unpacked;
    protected final EnumSet<Attr> _attrs;
    protected final boolean _isZip;
    protected static final Comparator<ZipEntry> ENTRY_COMP = new g();
    protected static final int DIGEST_BUFFER_SIZE = 5125;

    public static String computeDigest(int n2, File file, MessageDigest messageDigest, ProgressObserver progressObserver) throws IOException {
        block23: {
            byte[] byArray;
            block24: {
                messageDigest.reset();
                byArray = new byte[5125];
                boolean n3 = Resource.isJar(file) || Resource.isZip(file);
                if (!n3) break block24;
                ZipFile zipFile = null;
                try {
                    zipFile = new ZipFile(file);
                    ArrayList<? extends ZipEntry> iOException = Collections.list(zipFile.entries());
                    Collections.sort(iOException, ENTRY_COMP);
                    for (ZipEntry zipEntry : iOException) {
                        if (n2 < 2 && zipEntry.getName().startsWith("META-INF")) {
                            Resource.updateProgress(progressObserver, 0L, iOException.size());
                            continue;
                        }
                        try (InputStream l2 = zipFile.getInputStream(zipEntry);){
                            int n4;
                            while ((n4 = l2.read(byArray)) != -1) {
                                messageDigest.update(byArray, 0, n4);
                            }
                        }
                        Resource.updateProgress(progressObserver, 0L, iOException.size());
                    }
                }
                catch (Throwable throwable) {
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException iOException) {
                            Log.log.warning("Error closing", "path", file, "zip", zipFile, "error", iOException);
                        }
                    }
                    throw throwable;
                }
                try {
                    zipFile.close();
                }
                catch (IOException l3) {
                    Log.log.warning("Error closing", "path", file, "zip", zipFile, "error", l3);
                }
                break block23;
            }
            long l2 = file.length();
            long l3 = 0L;
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                int n3;
                while ((n3 = fileInputStream.read(byArray)) != -1) {
                    messageDigest.update(byArray, 0, n3);
                    Resource.updateProgress(progressObserver, l3 += (long)n3, l2);
                }
            }
        }
        return StringUtil.hexlate(messageDigest.digest());
    }

    public static boolean isZip(File object) {
        return ((String)(object = ((File)object).getName())).endsWith(".zip") || ((String)object).endsWith(".zip_new");
    }

    public static boolean isJar(File object) {
        return ((String)(object = ((File)object).getName())).endsWith(".jar") || ((String)object).endsWith(".jar_new");
    }

    public Resource(String string, URL uRL, File file, EnumSet<Attr> enumSet) {
        this._path = string;
        this._remote = uRL;
        this._local = file;
        this._localNew = new File(file.toString() + "_new");
        this._marker = new File(this._local.getPath() + "v");
        this._attrs = enumSet;
        this._isZip = Resource.isJar(file) || Resource.isZip(file);
        boolean bl = enumSet.contains((Object)Attr.UNPACK);
        if (bl && this._isZip) {
            this._unpacked = this._local.getParentFile();
        }
    }

    public String getPath() {
        return this._path;
    }

    public File getLocal() {
        return this._local;
    }

    public File getLocalNew() {
        return this._localNew;
    }

    public File getUnpacked() {
        return this._unpacked;
    }

    public File getFinalTarget() {
        if (this.shouldUnpack()) {
            return this.getUnpacked();
        }
        return this.getLocal();
    }

    public URL getRemote() {
        return this._remote;
    }

    public boolean shouldUnpack() {
        return this._attrs.contains((Object)Attr.UNPACK) && !SysProps.noUnpack();
    }

    public boolean shouldPredownload() {
        return this._attrs.contains((Object)Attr.PRELOAD);
    }

    public boolean isNative() {
        return this._attrs.contains((Object)Attr.NATIVE);
    }

    public String computeDigest(int n2, MessageDigest messageDigest, ProgressObserver progressObserver) throws IOException {
        File file = !this._local.toString().toLowerCase(Locale.ROOT).endsWith("getdown.txt") && this._localNew.exists() ? this._localNew : this._local;
        return Resource.computeDigest(n2, file, messageDigest, progressObserver);
    }

    public boolean isMarkedValid() {
        if (!this._local.exists()) {
            this.clearMarker();
            return false;
        }
        return this._marker.exists();
    }

    public void markAsValid() throws IOException {
        this._marker.createNewFile();
    }

    public void clearMarker() {
        if (this._marker.exists() && !FileUtil.deleteHarder(this._marker)) {
            Log.log.warning("Failed to erase marker file '" + String.valueOf(this._marker) + "'.", new Object[0]);
        }
    }

    public void install(boolean bl) throws IOException {
        File file = this.getLocalNew();
        File file2 = this.getLocal();
        Log.log.info("- " + String.valueOf(file), new Object[0]);
        if (!FileUtil.renameTo(file, file2)) {
            throw new IOException("Failed to rename " + String.valueOf(file) + " to " + String.valueOf(file2));
        }
        this.applyAttrs();
        if (bl) {
            this.markAsValid();
        }
    }

    public void unpack() throws IOException {
        if (!this._isZip) {
            throw new IOException("Requested to unpack non-jar file '" + String.valueOf(this._local) + "'.");
        }
        try (ZipFile zipFile = new ZipFile(this._local);){
            FileUtil.unpackJar(zipFile, this._unpacked, this._attrs.contains((Object)Attr.CLEAN));
            return;
        }
    }

    public void applyAttrs() throws IOException {
        if (this.shouldUnpack()) {
            this.unpack();
        }
        if (this._attrs.contains((Object)Attr.EXEC)) {
            FileUtil.makeExecutable(this._local);
        }
    }

    public void erase() {
        this.clearMarker();
        if (this._local.exists() && !FileUtil.deleteHarder(this._local)) {
            Log.log.warning("Failed to erase resource '" + String.valueOf(this._local) + "'.", new Object[0]);
        }
    }

    @Override
    public int compareTo(Resource resource) {
        return this._path.compareTo(resource._path);
    }

    public boolean equals(Object object) {
        if (object instanceof Resource) {
            return this._path.equals(((Resource)object)._path);
        }
        return false;
    }

    public int hashCode() {
        return this._path.hashCode();
    }

    public String toString() {
        return this._path;
    }

    protected static void updateProgress(ProgressObserver progressObserver, long l2, long l3) {
        if (progressObserver != null) {
            progressObserver.progress((int)(100L * l2 / l3));
        }
    }

    public static enum Attr {
        UNPACK,
        CLEAN,
        EXEC,
        PRELOAD,
        NATIVE;

    }
}

