/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.launcher;

import com.threerings.getdown.Log;
import com.threerings.getdown.data.Application;
import com.threerings.getdown.data.Build;
import com.threerings.getdown.data.EnvConfig;
import com.threerings.getdown.data.Resource;
import com.threerings.getdown.data.SysProps;
import com.threerings.getdown.launcher.AbortPanel;
import com.threerings.getdown.launcher.MultipleGetdownRunning;
import com.threerings.getdown.launcher.ProxyPanel;
import com.threerings.getdown.launcher.ProxyUtil;
import com.threerings.getdown.launcher.RotatingBackgrounds;
import com.threerings.getdown.launcher.StatusPanel;
import com.threerings.getdown.launcher.a;
import com.threerings.getdown.launcher.b;
import com.threerings.getdown.launcher.c;
import com.threerings.getdown.launcher.d;
import com.threerings.getdown.launcher.e;
import com.threerings.getdown.launcher.g;
import com.threerings.getdown.launcher.h;
import com.threerings.getdown.launcher.i;
import com.threerings.getdown.tools.Patcher;
import com.threerings.getdown.util.Config;
import com.threerings.getdown.util.FileUtil;
import com.threerings.getdown.util.LaunchUtil;
import com.threerings.getdown.util.MessageUtil;
import com.threerings.getdown.util.ProgressAggregator;
import com.threerings.getdown.util.ProgressObserver;
import com.threerings.getdown.util.StringUtil;
import com.threerings.getdown.util.VersionUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JLayeredPane;

public abstract class Getdown
implements Application.StatusDisplay,
RotatingBackgrounds.ImageLoader {
    protected final ProgressObserver _progobs = new i(this);
    protected final Application _app;
    protected Application.UpdateInterface _ifc = new Application.UpdateInterface(Config.EMPTY);
    protected ResourceBundle _msgs;
    protected Container _container;
    protected JLayeredPane _layers;
    protected StatusPanel _status;
    protected JButton _patchNotes;
    protected AbortPanel _abort;
    protected RotatingBackgrounds _background;
    protected boolean _dead;
    protected boolean _silent;
    protected boolean _launchInSilent;
    protected boolean _noUpdate;
    protected final long _startup;
    protected Set<Resource> _toInstallResources;
    protected boolean _readyToInstall;
    protected boolean _enableTracking = true;
    protected int _reportedProgress = 0;
    protected int _delay;
    protected int _stepMaxPercent;
    protected int _stepMinPercent;
    protected int _lastGlobalPercent;
    protected int _uiDisplayPercent;
    protected static final int MAX_LOOPS = 5;
    protected static final long FALLBACK_CHECK_TIME = 1000L;

    public static void run(Getdown getdown) {
        new a("Getdown", getdown).start();
    }

    public Getdown(EnvConfig envConfig) {
        try {
            this._silent = SysProps.silent();
            if (this._silent) {
                this._launchInSilent = SysProps.launchInSilent();
                this._noUpdate = SysProps.noUpdate();
            }
            if (!this._silent && GraphicsEnvironment.isHeadless()) {
                Log.log.info("Running in headless JVM, will attempt to operate without UI.", new Object[0]);
                this._silent = true;
                this._launchInSilent = true;
            }
            this._delay = SysProps.startDelay();
        }
        catch (SecurityException securityException) {}
        try {
            this._msgs = ResourceBundle.getBundle("com.threerings.getdown.messages");
        }
        catch (Exception exception) {
            String string = envConfig.appDir.toString();
            if (".".equals(string)) {
                string = System.getProperty("user.dir");
            }
            String string2 = "The directory in which this application is installed:\n" + string + "\nis invalid (" + exception.getMessage() + "). If the full path to the app directory contains the '!' character, this will trigger this error.";
            this.fail(string2);
        }
        this._app = new Application(envConfig);
        this._startup = System.currentTimeMillis();
    }

    public boolean isUpdateAvailable() {
        return this._readyToInstall && !this._toInstallResources.isEmpty();
    }

    public void install() throws IOException {
        if (SysProps.noInstall()) {
            Log.log.info("Skipping install due to 'no_install' sysprop.", new Object[0]);
            return;
        }
        if (this.isUpdateAvailable()) {
            Log.log.info("Installing " + this._toInstallResources.size() + " downloaded resources:", new Object[0]);
            for (Resource resource : this._toInstallResources) {
                resource.install(true);
            }
            this._toInstallResources.clear();
            this._readyToInstall = false;
            Log.log.info("Install completed.", new Object[0]);
            List<String> list = this._app.cleanupPatterns();
            if (!list.isEmpty()) {
                this.cleanupResources(list);
            }
            return;
        }
        Log.log.info("Nothing to install.", new Object[0]);
    }

    public void configProxy(String string, String string2, String string3, String string4) {
        Log.log.info("User configured proxy", "host", string, "port", string2);
        ProxyUtil.configProxy(this._app, string, string2, string3, string4);
        this.disposeContainer();
        this._container = null;
        Getdown.run(this);
    }

    protected void run() {
        if (this._msgs == null) {
            return;
        }
        Log.log.info("Getdown starting", "version", Build.version(), "built", Build.time());
        Object object = this._app.getLocalPath("");
        if (!((File)object).canWrite()) {
            if (".".equals(object = ((File)object).getPath())) {
                object = System.getProperty("user.dir");
            }
            this.fail(MessageUtil.tcompose("m.readonly_error", new String[]{object}));
            return;
        }
        this._dead = false;
        if (this.detectProxy() || this._app.allowOffline()) {
            this.getdown();
            return;
        }
        this.requestProxyInfo(false);
    }

    protected boolean detectProxy() {
        Log.log.info("Checking whether we need to use a proxy...", new Object[0]);
        try {
            this.readConfig(true);
        }
        catch (IOException iOException) {}
        boolean bl = SysProps.tryNoProxyFirst();
        if (!bl && ProxyUtil.autoDetectProxy(this._app)) {
            return true;
        }
        this.updateStatus("m.detecting_proxy");
        URL uRL = this._app.getConfigResource().getRemote();
        if (!ProxyUtil.canLoadWithoutProxy(uRL, bl ? 2 : 5)) {
            if (bl) {
                return ProxyUtil.autoDetectProxy(this._app);
            }
            return false;
        }
        Log.log.info("No proxy appears to be needed.", new Object[0]);
        if (!bl) {
            ProxyUtil.saveProxy(this._app, null, null);
        }
        return true;
    }

    protected void readConfig(boolean bl) throws IOException {
        Config config = this._app.init(true);
        if (bl) {
            Getdown getdown = this;
            getdown.doPredownloads(getdown._app.getResources());
        }
        this._ifc = new Application.UpdateInterface(config);
    }

    protected void requestProxyInfo(boolean bl) {
        if (this._silent) {
            Log.log.warning("Need a proxy, but we don't want to bother anyone. Exiting.", new Object[0]);
            return;
        }
        this._container = this.createContainer();
        this._dead = true;
        this.configureContainer();
        Getdown getdown = this;
        ProxyPanel proxyPanel = new ProxyPanel(getdown, getdown._msgs, bl);
        String[] stringArray = ProxyUtil.loadProxy(this._app);
        proxyPanel.setProxy(stringArray[0], stringArray[1]);
        this._container.add((Component)proxyPanel, "Center");
        this.showContainer();
    }

    protected void doPredownloads(Collection<Resource> iterator) {
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            if (!resource.shouldPredownload() || resource.getLocal().exists()) continue;
            arrayList.add(resource);
        }
        if (!arrayList.isEmpty()) {
            try {
                this.download(arrayList);
                for (Resource resource : arrayList) {
                    resource.install(false);
                }
                return;
            }
            catch (IOException iOException) {
                Log.log.warning("Failed to predownload resources. Continuing...", iOException);
            }
        }
    }

    protected void getdown() {
        try {
            try {
                this.readConfig(true);
            }
            catch (IOException iOException) {
                Log.log.warning("Failed to initialize: " + String.valueOf(iOException), new Object[0]);
                this._app.attemptRecovery(this);
                this.readConfig(true);
                this.createInterfaceAsync(true);
            }
            if (!this._noUpdate && !this._app.lockForUpdates()) {
                throw new MultipleGetdownRunning();
            }
            File file = this._app.getLocalPath("getdown.txt");
            if (!file.setLastModified(System.currentTimeMillis())) {
                Log.log.warning("Unable to set modtime on config file, will be unable to check for another instance of getdown running while this one waits.", new Object[0]);
            }
            if (this._delay > 0) {
                this._app.releaseLock();
                long l2 = file.lastModified();
                Log.log.info("Waiting " + this._delay + " minutes before beginning actual work.", new Object[0]);
                TimeUnit.MINUTES.sleep(this._delay);
                if (l2 < file.lastModified()) {
                    Log.log.warning("getdown.txt was modified while getdown was waiting.", new Object[0]);
                    throw new MultipleGetdownRunning();
                }
            }
            if (this._noUpdate) {
                Log.log.info("Launching without update!", new Object[0]);
                this.launch();
                return;
            }
            int[] nArray = new int[1];
            HashSet<Resource> hashSet = new HashSet<Resource>();
            this._toInstallResources = new HashSet<Resource>();
            this._readyToInstall = false;
            for (int i2 = 0; i2 < 5; ++i2) {
                this.setStep(Application.UpdateInterface.Step.VERIFY_METADATA);
                this.setStatusAsync("m.validating", -1, -1L, false);
                if (this._app.verifyMetadata(this)) {
                    Log.log.info("Application requires update.", new Object[0]);
                    this.update();
                    continue;
                }
                this.setStep(Application.UpdateInterface.Step.VERIFY_RESOURCES);
                this.setStatusAsync("m.validating", -1, -1L, false);
                HashSet<Resource> hashSet2 = new HashSet<Resource>();
                this._app.verifyResources(this._progobs, nArray, hashSet, this._toInstallResources, hashSet2);
                if (hashSet2.size() > 0) {
                    this._toInstallResources.addAll(hashSet2);
                    try {
                        this._enableTracking = nArray[0] == 0;
                        this.reportTrackingEvent("app_start", -1);
                        Log.log.info(hashSet2.size() + " of " + this._app.getAllActiveResources().size() + " rsrcs require update (" + nArray[0] + " assumed valid).", new Object[0]);
                        this.setStep(Application.UpdateInterface.Step.REDOWNLOAD_RESOURCES);
                        this.download(hashSet2);
                        this.reportTrackingEvent("app_complete", -1);
                        continue;
                    }
                    finally {
                        this._enableTracking = false;
                    }
                }
                if (!this._app.haveValidJavaVersion()) {
                    Log.log.info("Attempting to update Java VM...", new Object[0]);
                    this.setStep(Application.UpdateInterface.Step.UPDATE_JAVA);
                    this._enableTracking = true;
                    try {
                        this.updateJava();
                        continue;
                    }
                    finally {
                        this._enableTracking = false;
                    }
                }
                if (Boolean.getBoolean("check_unpacked")) {
                    File file2 = this._app.getLocalPath("unpacked.dat");
                    long l3 = -1L;
                    long l4 = this._app.getVersion();
                    if (!file2.exists()) {
                        file2.createNewFile();
                    } else {
                        l3 = VersionUtil.readVersion(file2);
                    }
                    if (l3 < l4) {
                        Log.log.info("Performing unpack", "version", l3, "aversion", l4);
                        this.setStep(Application.UpdateInterface.Step.UNPACK);
                        this.updateStatus("m.validating");
                        this._app.unpackResources(this._progobs, hashSet);
                        try {
                            VersionUtil.writeVersion(file2, l4);
                        }
                        catch (IOException iOException) {
                            Log.log.warning("Failed to update unpacked version", iOException);
                        }
                    }
                }
                this._readyToInstall = true;
                this.install();
                if (!this._silent || this._launchInSilent) {
                    this._app.lockForUpdates();
                    this.launch();
                }
                return;
            }
            Log.log.warning("Pants! We couldn't get the job done.", new Object[0]);
            throw new IOException("m.unable_to_repair");
        }
        catch (Exception exception) {
            switch (this._app.conn.state) {
                case NEED_PROXY: {
                    this.requestProxyInfo(false);
                    return;
                }
                case NEED_PROXY_AUTH: {
                    this.requestProxyInfo(true);
                    return;
                }
            }
            Log.log.warning("getdown() failed.", exception);
            this.fail(exception);
            this._app.releaseLock();
            return;
        }
    }

    @Override
    public void updateStatus(String string) {
        this.setStatusAsync(string, -1, -1L, true);
    }

    @Override
    public BufferedImage loadImage(String string) {
        if (StringUtil.isBlank(string)) {
            return null;
        }
        File file = null;
        try {
            String string2 = Locale.getDefault().getLanguage();
            file = this._app.getLocalPath(string.replace(".", "_" + string2 + "."));
            return ImageIO.read(file);
        }
        catch (IOException iOException) {
            try {
                file = this._app.getLocalPath(string);
                return ImageIO.read(file);
            }
            catch (IOException iOException2) {
                Log.log.warning("Failed to load image", "path", file, "error", iOException2);
                return null;
            }
        }
    }

    protected void updateJava() throws IOException {
        Object object = this._app.getJavaVMResource();
        if (object == null) {
            throw new IOException("m.java_download_failed");
        }
        String[] stringArray = this._app.getJavaLocalDir();
        Serializable serializable = new File((File)stringArray, "bin" + File.separator + "java.dll");
        if (serializable.exists()) {
            File file = serializable;
            if (!file.renameTo(file)) {
                Log.log.info("Cannot update local Java VM as it is in use.", new Object[0]);
                return;
            }
        }
        this.reportTrackingEvent("jvm_start", -1);
        this.updateStatus("m.downloading_java");
        serializable = new ArrayList<Resource>();
        serializable.add(object);
        this.download((Collection<Resource>)((Object)serializable));
        this.reportTrackingEvent("jvm_unpack", -1);
        this.updateStatus("m.unpacking_java");
        try {
            ((Resource)object).install(true);
        }
        catch (IOException iOException) {
            throw new IOException("m.java_unpack_failed", iOException);
        }
        FileUtil.makeExecutable(new File((File)stringArray, "bin/java"));
        FileUtil.makeExecutable(new File((File)stringArray, "lib/jspawnhelper"));
        FileUtil.makeExecutable(new File((File)stringArray, "lib/amd64/jspawnhelper"));
        object = LaunchUtil.getJVMBinaryPath((File)stringArray, false);
        stringArray = new String[]{object, "-Xshare:dump"};
        try {
            Log.log.info("Regenerating classes.jsa for " + (String)object + "...", new Object[0]);
            Runtime.getRuntime().exec(stringArray);
        }
        catch (Exception exception) {
            Log.log.warning("Failed to regenerate .jsa dump file", "error", exception);
        }
        this.reportTrackingEvent("jvm_complete", -1);
    }

    protected void update() throws IOException {
        this._app.clearValidationMarkers();
        Resource object3 = this._app.getPatchResource(null);
        if (object3 != null) {
            Object object = new ArrayList<Resource>();
            object.add(object3);
            for (Application.AuxGroup auxGroup : this._app.getAuxGroups()) {
                Resource resource;
                if (!this._app.isAuxGroupActive(auxGroup.name) || (resource = this._app.getPatchResource(auxGroup.name)) == null) continue;
                object.add((Resource)resource);
            }
            if (!StringUtil.isBlank(this._ifc.patchNotesUrl)) {
                this.createInterfaceAsync(false);
                EventQueue.invokeLater(new b(this));
            }
            this.setStep(Application.UpdateInterface.Step.DOWNLOAD);
            this.download((Collection<Resource>)object);
            this.setStep(Application.UpdateInterface.Step.PATCH);
            this.updateStatus("m.patching");
            long[] lArray = new long[object.size()];
            Object object2 = lArray;
            Arrays.fill(lArray, 1L);
            ProgressAggregator progressAggregator = new ProgressAggregator(this._progobs, (long[])object2);
            int n2 = 0;
            object = object.iterator();
            while (object.hasNext()) {
                Resource resource = (Resource)object.next();
                ProgressObserver progressObserver = progressAggregator.startElement(n2++);
                try {
                    if (!resource.getLocalNew().exists()) continue;
                    resource.install(false);
                    Patcher patcher = new Patcher();
                    patcher.patch(resource.getLocal().getParentFile(), resource.getLocal(), progressObserver);
                }
                catch (Exception exception) {
                    Log.log.warning("Failed to apply patch", "prsrc", resource, exception);
                }
                if (FileUtil.deleteHarder(resource.getLocal())) continue;
                Log.log.warning("Failed to delete '" + String.valueOf(resource) + "'.", new Object[0]);
            }
        }
        this._app.updateMetadata();
        this.readConfig(false);
    }

    protected void download(Collection<Resource> collection) throws IOException {
        this.createInterfaceAsync(false);
        Getdown getdown = this;
        c c2 = new c(getdown, getdown._app.conn);
        if (!c2.download(collection, this._app.maxConcurrentDownloads())) {
            throw new MultipleGetdownRunning();
        }
    }

    void cleanupResources(List<String> hashSet) {
        String iterator2 = this._app.getAppDir().getAbsolutePath();
        HashSet<Path> hashSet2 = new HashSet<Path>();
        for (String string : hashSet) {
            hashSet2.addAll(FileUtil.getFilePathsByGlob(iterator2, string));
        }
        hashSet = new HashSet<Path>();
        for (Resource resource : this._app.getAllActiveResources()) {
            hashSet.add(resource.getLocal().toPath().toAbsolutePath());
        }
        HashSet<Path> hashSet3 = new HashSet<Path>();
        for (Path path : hashSet2) {
            if (hashSet.contains(path)) continue;
            hashSet3.add(path);
        }
        if (!hashSet3.isEmpty()) {
            for (Path path : hashSet3) {
                path.toFile().delete();
            }
        }
    }

    protected void launch() {
        this.setStep(Application.UpdateInterface.Step.LAUNCH);
        this.setStatusAsync("m.launching", this.stepToGlobalPercent(100), -1L, false);
        try {
            if (this.invokeDirect()) {
                this.disposeContainer();
                this._app.releaseLock();
                this._app.invokeDirect();
            } else {
                Process process;
                if (this._app.hasOptimumJvmArgs()) {
                    process = this._app.createProcess(true);
                    long l2 = System.currentTimeMillis() + 1000L;
                    boolean bl = false;
                    while (l2 > System.currentTimeMillis()) {
                        try {
                            bl = process.exitValue() != 0;
                            break;
                        }
                        catch (IllegalThreadStateException illegalThreadStateException) {
                            Thread.yield();
                        }
                    }
                    if (bl) {
                        Log.log.info("Failed to launch with optimum arguments; falling back.", new Object[0]);
                        process = this._app.createProcess(false);
                    }
                } else {
                    process = this._app.createProcess(false);
                }
                process.getInputStream().close();
                process.getOutputStream().close();
                InputStream inputStream = process.getErrorStream();
                if (LaunchUtil.mustMonitorChildren()) {
                    this.disposeContainer();
                    this._container = null;
                    Getdown.copyStream(inputStream, System.err);
                    Log.log.info("Process exited: " + process.waitFor(), new Object[0]);
                } else {
                    d d2 = new d(this, inputStream);
                    d2.setDaemon(true);
                    d2.start();
                }
            }
            long l3 = System.currentTimeMillis() - this._startup;
            long l4 = (long)this._ifc.minShowSeconds * 1000L;
            if (this._container != null && l3 < l4) {
                try {
                    TimeUnit.MILLISECONDS.sleep(l4 - l3);
                }
                catch (Exception exception) {}
            }
            this.setStatusAsync(null, 100, -1L, false);
            this.exit(0);
            return;
        }
        catch (Exception exception) {
            Log.log.warning("launch() failed.", exception);
            return;
        }
    }

    protected void createInterfaceAsync(boolean bl) {
        if (this._silent || this._container != null && !bl) {
            return;
        }
        EventQueue.invokeLater(new e(this, bl));
    }

    protected void initInterface() {
        Object object = this.getBackground();
        if (this._background == null || ((RotatingBackgrounds)object).getNumImages() > 0) {
            this._background = object;
        }
        this._status.init(this._ifc, this._background, this.getProgressImage());
        object = this._status.getPreferredSize();
        this._status.setSize((Dimension)object);
        this._layers.setPreferredSize((Dimension)object);
        this._patchNotes.setBounds(this._ifc.patchNotes.x, this._ifc.patchNotes.y, this._ifc.patchNotes.width, this._ifc.patchNotes.height);
        this._patchNotes.setVisible(false);
        this._uiDisplayPercent = this._lastGlobalPercent;
        Getdown getdown = this;
        getdown._lastGlobalPercent = 0;
        getdown._stepMinPercent = 0;
    }

    protected RotatingBackgrounds getBackground() {
        if (this._ifc.rotatingBackgrounds != null) {
            if (this._ifc.backgroundImage != null) {
                Log.log.warning("ui.background_image and ui.rotating_background were both specified. The rotating images are being used.", new Object[0]);
            }
            return new RotatingBackgrounds(this._ifc.rotatingBackgrounds, this._ifc.errorBackground, this);
        }
        if (this._ifc.backgroundImage != null) {
            Getdown getdown = this;
            return new RotatingBackgrounds(getdown.loadImage(getdown._ifc.backgroundImage));
        }
        return new RotatingBackgrounds();
    }

    protected Image getProgressImage() {
        Getdown getdown = this;
        return getdown.loadImage(getdown._ifc.progressImage);
    }

    protected void handleWindowClose() {
        if (this._dead) {
            this.exit(0);
            return;
        }
        if (this._abort == null) {
            Getdown getdown = this;
            this._abort = new AbortPanel(getdown, getdown._msgs);
        }
        this._abort.pack();
        com.a.a.a.a.a(this._abort);
        this._abort.setVisible(true);
        this._abort.setState(0);
        this._abort.requestFocus();
    }

    private void fail(Exception exception) {
        String string;
        block4: {
            String string2;
            block3: {
                block2: {
                    string = exception.getMessage();
                    if (string != null) break block2;
                    string2 = MessageUtil.compose("m.unknown_error", this._ifc.installError);
                    break block3;
                }
                if (string.startsWith("m.")) break block4;
                string = MessageUtil.taint(string);
                string2 = exception instanceof FileNotFoundException ? MessageUtil.compose("m.missing_resource", string, this._ifc.installError) : MessageUtil.compose("m.init_error", string, this._ifc.installError);
            }
            string = string2;
        }
        this.fail(string);
    }

    protected void fail(String string) {
        this._dead = true;
        this.setStatusAsync(string, this.stepToGlobalPercent(0), -1L, true);
    }

    protected void setStep(Application.UpdateInterface.Step object) {
        int n2 = -1;
        for (Integer n3 : this._ifc.stepPercentages.get(object)) {
            if (n3 <= this._stepMaxPercent) continue;
            n2 = n3;
            break;
        }
        if (n2 == -1) {
            return;
        }
        this._stepMaxPercent = n2;
        this._stepMinPercent = this._lastGlobalPercent;
    }

    protected int stepToGlobalPercent(int n2) {
        int n3 = (this._stepMaxPercent - this._uiDisplayPercent) * 100 / (100 - this._uiDisplayPercent);
        this._lastGlobalPercent = Math.max(this._lastGlobalPercent, this._stepMinPercent + n2 * (n3 - this._stepMinPercent) / 100);
        return this._lastGlobalPercent;
    }

    protected void setStatusAsync(String string, int n2, long l2, boolean bl) {
        if (this._status == null && bl) {
            this.createInterfaceAsync(false);
        }
        EventQueue.invokeLater(new g(this, string, n2, l2));
    }

    protected void reportTrackingEvent(String object, int n2) {
        if (!this._enableTracking) {
            return;
        }
        if (n2 > 0) {
            do {
                if ((object = this._app.getTrackingProgressURL(++this._reportedProgress)) == null) continue;
                this.reportProgress((URL)object);
            } while (this._reportedProgress <= n2);
            return;
        }
        if ((object = this._app.getTrackingURL((String)object)) != null) {
            this.reportProgress((URL)object);
        }
    }

    protected abstract Container createContainer();

    protected abstract void configureContainer();

    protected abstract void showContainer();

    protected abstract void disposeContainer();

    protected boolean invokeDirect() {
        return SysProps.direct();
    }

    protected abstract void showDocument(String var1);

    protected abstract void exit(int var1);

    protected static void copyStream(InputStream inputStream, PrintStream printStream) {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string = bufferedReader.readLine()) != null) {
                printStream.print(string);
                printStream.flush();
            }
            return;
        }
        catch (IOException iOException) {
            Log.log.warning("Failure copying", "in", inputStream, "out", printStream, "error", iOException);
            return;
        }
    }

    protected void reportProgress(URL object) {
        object = new h(this, "Progress reporter", (URL)object);
        ((Thread)object).setDaemon(true);
        ((Thread)object).start();
    }
}

